/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class Placement
extends APINode {
    @SerializedName(value="audience_network_positions")
    private List<String> mAudienceNetworkPositions = null;
    @SerializedName(value="device_platforms")
    private List<EnumDevicePlatforms> mDevicePlatforms = null;
    @SerializedName(value="effective_audience_network_positions")
    private List<String> mEffectiveAudienceNetworkPositions = null;
    @SerializedName(value="effective_device_platforms")
    private List<EnumEffectiveDevicePlatforms> mEffectiveDevicePlatforms = null;
    @SerializedName(value="effective_facebook_positions")
    private List<String> mEffectiveFacebookPositions = null;
    @SerializedName(value="effective_instagram_positions")
    private List<String> mEffectiveInstagramPositions = null;
    @SerializedName(value="effective_messenger_positions")
    private List<String> mEffectiveMessengerPositions = null;
    @SerializedName(value="effective_oculus_positions")
    private List<String> mEffectiveOculusPositions = null;
    @SerializedName(value="effective_publisher_platforms")
    private List<String> mEffectivePublisherPlatforms = null;
    @SerializedName(value="effective_threads_positions")
    private List<String> mEffectiveThreadsPositions = null;
    @SerializedName(value="effective_whatsapp_positions")
    private List<String> mEffectiveWhatsappPositions = null;
    @SerializedName(value="facebook_positions")
    private List<String> mFacebookPositions = null;
    @SerializedName(value="instagram_positions")
    private List<String> mInstagramPositions = null;
    @SerializedName(value="messenger_positions")
    private List<String> mMessengerPositions = null;
    @SerializedName(value="oculus_positions")
    private List<String> mOculusPositions = null;
    @SerializedName(value="publisher_platforms")
    private List<String> mPublisherPlatforms = null;
    @SerializedName(value="threads_positions")
    private List<String> mThreadsPositions = null;
    @SerializedName(value="whatsapp_positions")
    private List<String> mWhatsappPositions = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static Placement loadJSON(String json, APIContext context, String header) {
        Placement placement = (Placement)Placement.getGson().fromJson(json, Placement.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(placement.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        placement.context = context;
        placement.rawValue = json;
        placement.header = header;
        return placement;
    }

    public static APINodeList<Placement> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Placement> placements = new APINodeList<Placement>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        placements.add(Placement.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return placements;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            placements.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        placements.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            placements.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            placements.add(Placement.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                placements.add(Placement.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            placements.add(Placement.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return placements;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        placements.add(Placement.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return placements;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        placements.add(Placement.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return placements;
                }
                placements.clear();
                placements.add(Placement.loadJSON(json, context, header));
                return placements;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Placement.getGson().toJson((Object)this);
    }

    public List<String> getFieldAudienceNetworkPositions() {
        return this.mAudienceNetworkPositions;
    }

    public Placement setFieldAudienceNetworkPositions(List<String> value) {
        this.mAudienceNetworkPositions = value;
        return this;
    }

    public List<EnumDevicePlatforms> getFieldDevicePlatforms() {
        return this.mDevicePlatforms;
    }

    public Placement setFieldDevicePlatforms(List<EnumDevicePlatforms> value) {
        this.mDevicePlatforms = value;
        return this;
    }

    public List<String> getFieldEffectiveAudienceNetworkPositions() {
        return this.mEffectiveAudienceNetworkPositions;
    }

    public Placement setFieldEffectiveAudienceNetworkPositions(List<String> value) {
        this.mEffectiveAudienceNetworkPositions = value;
        return this;
    }

    public List<EnumEffectiveDevicePlatforms> getFieldEffectiveDevicePlatforms() {
        return this.mEffectiveDevicePlatforms;
    }

    public Placement setFieldEffectiveDevicePlatforms(List<EnumEffectiveDevicePlatforms> value) {
        this.mEffectiveDevicePlatforms = value;
        return this;
    }

    public List<String> getFieldEffectiveFacebookPositions() {
        return this.mEffectiveFacebookPositions;
    }

    public Placement setFieldEffectiveFacebookPositions(List<String> value) {
        this.mEffectiveFacebookPositions = value;
        return this;
    }

    public List<String> getFieldEffectiveInstagramPositions() {
        return this.mEffectiveInstagramPositions;
    }

    public Placement setFieldEffectiveInstagramPositions(List<String> value) {
        this.mEffectiveInstagramPositions = value;
        return this;
    }

    public List<String> getFieldEffectiveMessengerPositions() {
        return this.mEffectiveMessengerPositions;
    }

    public Placement setFieldEffectiveMessengerPositions(List<String> value) {
        this.mEffectiveMessengerPositions = value;
        return this;
    }

    public List<String> getFieldEffectiveOculusPositions() {
        return this.mEffectiveOculusPositions;
    }

    public Placement setFieldEffectiveOculusPositions(List<String> value) {
        this.mEffectiveOculusPositions = value;
        return this;
    }

    public List<String> getFieldEffectivePublisherPlatforms() {
        return this.mEffectivePublisherPlatforms;
    }

    public Placement setFieldEffectivePublisherPlatforms(List<String> value) {
        this.mEffectivePublisherPlatforms = value;
        return this;
    }

    public List<String> getFieldEffectiveThreadsPositions() {
        return this.mEffectiveThreadsPositions;
    }

    public Placement setFieldEffectiveThreadsPositions(List<String> value) {
        this.mEffectiveThreadsPositions = value;
        return this;
    }

    public List<String> getFieldEffectiveWhatsappPositions() {
        return this.mEffectiveWhatsappPositions;
    }

    public Placement setFieldEffectiveWhatsappPositions(List<String> value) {
        this.mEffectiveWhatsappPositions = value;
        return this;
    }

    public List<String> getFieldFacebookPositions() {
        return this.mFacebookPositions;
    }

    public Placement setFieldFacebookPositions(List<String> value) {
        this.mFacebookPositions = value;
        return this;
    }

    public List<String> getFieldInstagramPositions() {
        return this.mInstagramPositions;
    }

    public Placement setFieldInstagramPositions(List<String> value) {
        this.mInstagramPositions = value;
        return this;
    }

    public List<String> getFieldMessengerPositions() {
        return this.mMessengerPositions;
    }

    public Placement setFieldMessengerPositions(List<String> value) {
        this.mMessengerPositions = value;
        return this;
    }

    public List<String> getFieldOculusPositions() {
        return this.mOculusPositions;
    }

    public Placement setFieldOculusPositions(List<String> value) {
        this.mOculusPositions = value;
        return this;
    }

    public List<String> getFieldPublisherPlatforms() {
        return this.mPublisherPlatforms;
    }

    public Placement setFieldPublisherPlatforms(List<String> value) {
        this.mPublisherPlatforms = value;
        return this;
    }

    public List<String> getFieldThreadsPositions() {
        return this.mThreadsPositions;
    }

    public Placement setFieldThreadsPositions(List<String> value) {
        this.mThreadsPositions = value;
        return this;
    }

    public List<String> getFieldWhatsappPositions() {
        return this.mWhatsappPositions;
    }

    public Placement setFieldWhatsappPositions(List<String> value) {
        this.mWhatsappPositions = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Placement copyFrom(Placement instance) {
        this.mAudienceNetworkPositions = instance.mAudienceNetworkPositions;
        this.mDevicePlatforms = instance.mDevicePlatforms;
        this.mEffectiveAudienceNetworkPositions = instance.mEffectiveAudienceNetworkPositions;
        this.mEffectiveDevicePlatforms = instance.mEffectiveDevicePlatforms;
        this.mEffectiveFacebookPositions = instance.mEffectiveFacebookPositions;
        this.mEffectiveInstagramPositions = instance.mEffectiveInstagramPositions;
        this.mEffectiveMessengerPositions = instance.mEffectiveMessengerPositions;
        this.mEffectiveOculusPositions = instance.mEffectiveOculusPositions;
        this.mEffectivePublisherPlatforms = instance.mEffectivePublisherPlatforms;
        this.mEffectiveThreadsPositions = instance.mEffectiveThreadsPositions;
        this.mEffectiveWhatsappPositions = instance.mEffectiveWhatsappPositions;
        this.mFacebookPositions = instance.mFacebookPositions;
        this.mInstagramPositions = instance.mInstagramPositions;
        this.mMessengerPositions = instance.mMessengerPositions;
        this.mOculusPositions = instance.mOculusPositions;
        this.mPublisherPlatforms = instance.mPublisherPlatforms;
        this.mThreadsPositions = instance.mThreadsPositions;
        this.mWhatsappPositions = instance.mWhatsappPositions;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Placement> getParser() {
        return new APIRequest.ResponseParser<Placement>(){

            @Override
            public APINodeList<Placement> parseResponse(String response, APIContext context, APIRequest<Placement> request, String header) throws APIException.MalformedResponseException {
                return Placement.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumEffectiveDevicePlatforms {
        VALUE_DESKTOP("desktop"),
        VALUE_MOBILE("mobile");

        private String value;

        private EnumEffectiveDevicePlatforms(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDevicePlatforms {
        VALUE_DESKTOP("desktop"),
        VALUE_MOBILE("mobile");

        private String value;

        private EnumDevicePlatforms(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

