/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ProductCatalogDataSource
extends APINode {
    @SerializedName(value="app_id")
    private String mAppId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ingestion_source_type")
    private String mIngestionSourceType = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="upload_type")
    private String mUploadType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductCatalogDataSource loadJSON(String json, APIContext context, String header) {
        ProductCatalogDataSource productCatalogDataSource = (ProductCatalogDataSource)ProductCatalogDataSource.getGson().fromJson(json, ProductCatalogDataSource.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogDataSource.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogDataSource.context = context;
        productCatalogDataSource.rawValue = json;
        productCatalogDataSource.header = header;
        return productCatalogDataSource;
    }

    public static APINodeList<ProductCatalogDataSource> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogDataSource> productCatalogDataSources = new APINodeList<ProductCatalogDataSource>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogDataSources.add(ProductCatalogDataSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productCatalogDataSources;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogDataSources.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogDataSources.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogDataSources.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogDataSources.add(ProductCatalogDataSource.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogDataSources.add(ProductCatalogDataSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogDataSources.add(ProductCatalogDataSource.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productCatalogDataSources;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogDataSources.add(ProductCatalogDataSource.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productCatalogDataSources;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogDataSources.add(ProductCatalogDataSource.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogDataSources;
                }
                productCatalogDataSources.clear();
                productCatalogDataSources.add(ProductCatalogDataSource.loadJSON(json, context, header));
                return productCatalogDataSources;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogDataSource.getGson().toJson((Object)this);
    }

    public String getFieldAppId() {
        return this.mAppId;
    }

    public ProductCatalogDataSource setFieldAppId(String value) {
        this.mAppId = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ProductCatalogDataSource setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldIngestionSourceType() {
        return this.mIngestionSourceType;
    }

    public ProductCatalogDataSource setFieldIngestionSourceType(String value) {
        this.mIngestionSourceType = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public ProductCatalogDataSource setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldUploadType() {
        return this.mUploadType;
    }

    public ProductCatalogDataSource setFieldUploadType(String value) {
        this.mUploadType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogDataSource copyFrom(ProductCatalogDataSource instance) {
        this.mAppId = instance.mAppId;
        this.mId = instance.mId;
        this.mIngestionSourceType = instance.mIngestionSourceType;
        this.mName = instance.mName;
        this.mUploadType = instance.mUploadType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogDataSource> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogDataSource>(){

            @Override
            public APINodeList<ProductCatalogDataSource> parseResponse(String response, APIContext context, APIRequest<ProductCatalogDataSource> request, String header) throws APIException.MalformedResponseException {
                return ProductCatalogDataSource.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumIngestionSourceType {
        VALUE_ALL("ALL"),
        VALUE_PRIMARY("PRIMARY"),
        VALUE_SUPPLEMENTARY("SUPPLEMENTARY");

        private String value;

        private EnumIngestionSourceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

