/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ThirdPartyPartnerLiftRequest
extends APINode {
    @SerializedName(value="ad_entities")
    private List<String> mAdEntities = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="holdout_size")
    private Double mHoldoutSize = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="legacy_ads_data_partner_id")
    private String mLegacyAdsDataPartnerId = null;
    @SerializedName(value="legacy_ads_data_partner_name")
    private String mLegacyAdsDataPartnerName = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="owner_instance_id")
    private String mOwnerInstanceId = null;
    @SerializedName(value="partner_household_graph_dataset_id")
    private String mPartnerHouseholdGraphDatasetId = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="study_cells")
    private List<String> mStudyCells = null;
    @SerializedName(value="study_end_time")
    private String mStudyEndTime = null;
    @SerializedName(value="study_start_time")
    private String mStudyStartTime = null;
    protected static Gson gson = null;

    ThirdPartyPartnerLiftRequest() {
    }

    public ThirdPartyPartnerLiftRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ThirdPartyPartnerLiftRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ThirdPartyPartnerLiftRequest fetch() throws APIException {
        ThirdPartyPartnerLiftRequest newInstance = ThirdPartyPartnerLiftRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ThirdPartyPartnerLiftRequest fetchById(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerLiftRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ThirdPartyPartnerLiftRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerLiftRequest.fetchByIdAsync(id.toString(), context);
    }

    public static ThirdPartyPartnerLiftRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ThirdPartyPartnerLiftRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ThirdPartyPartnerLiftRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ThirdPartyPartnerLiftRequest>(context, "", "/", "GET", ThirdPartyPartnerLiftRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ThirdPartyPartnerLiftRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ThirdPartyPartnerLiftRequest>(context, "", "/", "GET", ThirdPartyPartnerLiftRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ThirdPartyPartnerLiftRequest loadJSON(String json, APIContext context, String header) {
        ThirdPartyPartnerLiftRequest thirdPartyPartnerLiftRequest = (ThirdPartyPartnerLiftRequest)ThirdPartyPartnerLiftRequest.getGson().fromJson(json, ThirdPartyPartnerLiftRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(thirdPartyPartnerLiftRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        thirdPartyPartnerLiftRequest.context = context;
        thirdPartyPartnerLiftRequest.rawValue = json;
        thirdPartyPartnerLiftRequest.header = header;
        return thirdPartyPartnerLiftRequest;
    }

    public static APINodeList<ThirdPartyPartnerLiftRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ThirdPartyPartnerLiftRequest> thirdPartyPartnerLiftRequests = new APINodeList<ThirdPartyPartnerLiftRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        thirdPartyPartnerLiftRequests.add(ThirdPartyPartnerLiftRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return thirdPartyPartnerLiftRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            thirdPartyPartnerLiftRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        thirdPartyPartnerLiftRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            thirdPartyPartnerLiftRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            thirdPartyPartnerLiftRequests.add(ThirdPartyPartnerLiftRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                thirdPartyPartnerLiftRequests.add(ThirdPartyPartnerLiftRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            thirdPartyPartnerLiftRequests.add(ThirdPartyPartnerLiftRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return thirdPartyPartnerLiftRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        thirdPartyPartnerLiftRequests.add(ThirdPartyPartnerLiftRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return thirdPartyPartnerLiftRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        thirdPartyPartnerLiftRequests.add(ThirdPartyPartnerLiftRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return thirdPartyPartnerLiftRequests;
                }
                thirdPartyPartnerLiftRequests.clear();
                thirdPartyPartnerLiftRequests.add(ThirdPartyPartnerLiftRequest.loadJSON(json, context, header));
                return thirdPartyPartnerLiftRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ThirdPartyPartnerLiftRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAdEntities() {
        return this.mAdEntities;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Double getFieldHoldoutSize() {
        return this.mHoldoutSize;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLegacyAdsDataPartnerId() {
        return this.mLegacyAdsDataPartnerId;
    }

    public String getFieldLegacyAdsDataPartnerName() {
        return this.mLegacyAdsDataPartnerName;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public String getFieldOwnerInstanceId() {
        return this.mOwnerInstanceId;
    }

    public String getFieldPartnerHouseholdGraphDatasetId() {
        return this.mPartnerHouseholdGraphDatasetId;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public List<String> getFieldStudyCells() {
        return this.mStudyCells;
    }

    public String getFieldStudyEndTime() {
        return this.mStudyEndTime;
    }

    public String getFieldStudyStartTime() {
        return this.mStudyStartTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ThirdPartyPartnerLiftRequest copyFrom(ThirdPartyPartnerLiftRequest instance) {
        this.mAdEntities = instance.mAdEntities;
        this.mCountry = instance.mCountry;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mHoldoutSize = instance.mHoldoutSize;
        this.mId = instance.mId;
        this.mLegacyAdsDataPartnerId = instance.mLegacyAdsDataPartnerId;
        this.mLegacyAdsDataPartnerName = instance.mLegacyAdsDataPartnerName;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOwnerInstanceId = instance.mOwnerInstanceId;
        this.mPartnerHouseholdGraphDatasetId = instance.mPartnerHouseholdGraphDatasetId;
        this.mRegion = instance.mRegion;
        this.mStatus = instance.mStatus;
        this.mStudyCells = instance.mStudyCells;
        this.mStudyEndTime = instance.mStudyEndTime;
        this.mStudyStartTime = instance.mStudyStartTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ThirdPartyPartnerLiftRequest> getParser() {
        return new APIRequest.ResponseParser<ThirdPartyPartnerLiftRequest>(){

            @Override
            public APINodeList<ThirdPartyPartnerLiftRequest> parseResponse(String response, APIContext context, APIRequest<ThirdPartyPartnerLiftRequest> request, String header) throws APIException.MalformedResponseException {
                return ThirdPartyPartnerLiftRequest.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_CREATED("CREATED"),
        VALUE_FAILURE("FAILURE"),
        VALUE_IN_PROGRESS("IN_PROGRESS"),
        VALUE_SCHEDULED("SCHEDULED"),
        VALUE_SUCCESS("SUCCESS");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ThirdPartyPartnerLiftRequest> {
        ThirdPartyPartnerLiftRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_entities", "country", "created_time", "description", "holdout_size", "id", "legacy_ads_data_partner_id", "legacy_ads_data_partner_name", "modified_time", "owner_instance_id", "partner_household_graph_dataset_id", "region", "status", "study_cells", "study_end_time", "study_start_time"};

        @Override
        public ThirdPartyPartnerLiftRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ThirdPartyPartnerLiftRequest parseResponse(String response, String header) throws APIException {
            return ThirdPartyPartnerLiftRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ThirdPartyPartnerLiftRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ThirdPartyPartnerLiftRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ThirdPartyPartnerLiftRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ThirdPartyPartnerLiftRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ThirdPartyPartnerLiftRequest>(){

                public ThirdPartyPartnerLiftRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdEntitiesField() {
            return this.requestAdEntitiesField(true);
        }

        public APIRequestGet requestAdEntitiesField(boolean value) {
            this.requestField("ad_entities", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestHoldoutSizeField() {
            return this.requestHoldoutSizeField(true);
        }

        public APIRequestGet requestHoldoutSizeField(boolean value) {
            this.requestField("holdout_size", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLegacyAdsDataPartnerIdField() {
            return this.requestLegacyAdsDataPartnerIdField(true);
        }

        public APIRequestGet requestLegacyAdsDataPartnerIdField(boolean value) {
            this.requestField("legacy_ads_data_partner_id", value);
            return this;
        }

        public APIRequestGet requestLegacyAdsDataPartnerNameField() {
            return this.requestLegacyAdsDataPartnerNameField(true);
        }

        public APIRequestGet requestLegacyAdsDataPartnerNameField(boolean value) {
            this.requestField("legacy_ads_data_partner_name", value);
            return this;
        }

        public APIRequestGet requestModifiedTimeField() {
            return this.requestModifiedTimeField(true);
        }

        public APIRequestGet requestModifiedTimeField(boolean value) {
            this.requestField("modified_time", value);
            return this;
        }

        public APIRequestGet requestOwnerInstanceIdField() {
            return this.requestOwnerInstanceIdField(true);
        }

        public APIRequestGet requestOwnerInstanceIdField(boolean value) {
            this.requestField("owner_instance_id", value);
            return this;
        }

        public APIRequestGet requestPartnerHouseholdGraphDatasetIdField() {
            return this.requestPartnerHouseholdGraphDatasetIdField(true);
        }

        public APIRequestGet requestPartnerHouseholdGraphDatasetIdField(boolean value) {
            this.requestField("partner_household_graph_dataset_id", value);
            return this;
        }

        public APIRequestGet requestRegionField() {
            return this.requestRegionField(true);
        }

        public APIRequestGet requestRegionField(boolean value) {
            this.requestField("region", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStudyCellsField() {
            return this.requestStudyCellsField(true);
        }

        public APIRequestGet requestStudyCellsField(boolean value) {
            this.requestField("study_cells", value);
            return this;
        }

        public APIRequestGet requestStudyEndTimeField() {
            return this.requestStudyEndTimeField(true);
        }

        public APIRequestGet requestStudyEndTimeField(boolean value) {
            this.requestField("study_end_time", value);
            return this;
        }

        public APIRequestGet requestStudyStartTimeField() {
            return this.requestStudyStartTimeField(true);
        }

        public APIRequestGet requestStudyStartTimeField(boolean value) {
            this.requestField("study_start_time", value);
            return this;
        }
    }
}

