/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ThirdPartyPartnerPanelRequest
extends APINode {
    @SerializedName(value="adentities_ids")
    private List<String> mAdentitiesIds = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="owner_instance_id")
    private String mOwnerInstanceId = null;
    @SerializedName(value="owner_panel_id")
    private String mOwnerPanelId = null;
    @SerializedName(value="owner_panel_name")
    private String mOwnerPanelName = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="study_end_time")
    private String mStudyEndTime = null;
    @SerializedName(value="study_start_time")
    private String mStudyStartTime = null;
    @SerializedName(value="study_type")
    private EnumStudyType mStudyType = null;
    protected static Gson gson = null;

    ThirdPartyPartnerPanelRequest() {
    }

    public ThirdPartyPartnerPanelRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ThirdPartyPartnerPanelRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ThirdPartyPartnerPanelRequest fetch() throws APIException {
        ThirdPartyPartnerPanelRequest newInstance = ThirdPartyPartnerPanelRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ThirdPartyPartnerPanelRequest fetchById(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerPanelRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ThirdPartyPartnerPanelRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerPanelRequest.fetchByIdAsync(id.toString(), context);
    }

    public static ThirdPartyPartnerPanelRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ThirdPartyPartnerPanelRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ThirdPartyPartnerPanelRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ThirdPartyPartnerPanelRequest>(context, "", "/", "GET", ThirdPartyPartnerPanelRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ThirdPartyPartnerPanelRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ThirdPartyPartnerPanelRequest>(context, "", "/", "GET", ThirdPartyPartnerPanelRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ThirdPartyPartnerPanelRequest loadJSON(String json, APIContext context, String header) {
        ThirdPartyPartnerPanelRequest thirdPartyPartnerPanelRequest = (ThirdPartyPartnerPanelRequest)ThirdPartyPartnerPanelRequest.getGson().fromJson(json, ThirdPartyPartnerPanelRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(thirdPartyPartnerPanelRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        thirdPartyPartnerPanelRequest.context = context;
        thirdPartyPartnerPanelRequest.rawValue = json;
        thirdPartyPartnerPanelRequest.header = header;
        return thirdPartyPartnerPanelRequest;
    }

    public static APINodeList<ThirdPartyPartnerPanelRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ThirdPartyPartnerPanelRequest> thirdPartyPartnerPanelRequests = new APINodeList<ThirdPartyPartnerPanelRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        thirdPartyPartnerPanelRequests.add(ThirdPartyPartnerPanelRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return thirdPartyPartnerPanelRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            thirdPartyPartnerPanelRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        thirdPartyPartnerPanelRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            thirdPartyPartnerPanelRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            thirdPartyPartnerPanelRequests.add(ThirdPartyPartnerPanelRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                thirdPartyPartnerPanelRequests.add(ThirdPartyPartnerPanelRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            thirdPartyPartnerPanelRequests.add(ThirdPartyPartnerPanelRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return thirdPartyPartnerPanelRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        thirdPartyPartnerPanelRequests.add(ThirdPartyPartnerPanelRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return thirdPartyPartnerPanelRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        thirdPartyPartnerPanelRequests.add(ThirdPartyPartnerPanelRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return thirdPartyPartnerPanelRequests;
                }
                thirdPartyPartnerPanelRequests.clear();
                thirdPartyPartnerPanelRequests.add(ThirdPartyPartnerPanelRequest.loadJSON(json, context, header));
                return thirdPartyPartnerPanelRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ThirdPartyPartnerPanelRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAdentitiesIds() {
        return this.mAdentitiesIds;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public String getFieldOwnerInstanceId() {
        return this.mOwnerInstanceId;
    }

    public String getFieldOwnerPanelId() {
        return this.mOwnerPanelId;
    }

    public String getFieldOwnerPanelName() {
        return this.mOwnerPanelName;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldStudyEndTime() {
        return this.mStudyEndTime;
    }

    public String getFieldStudyStartTime() {
        return this.mStudyStartTime;
    }

    public EnumStudyType getFieldStudyType() {
        return this.mStudyType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ThirdPartyPartnerPanelRequest copyFrom(ThirdPartyPartnerPanelRequest instance) {
        this.mAdentitiesIds = instance.mAdentitiesIds;
        this.mCountry = instance.mCountry;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOwnerInstanceId = instance.mOwnerInstanceId;
        this.mOwnerPanelId = instance.mOwnerPanelId;
        this.mOwnerPanelName = instance.mOwnerPanelName;
        this.mStatus = instance.mStatus;
        this.mStudyEndTime = instance.mStudyEndTime;
        this.mStudyStartTime = instance.mStudyStartTime;
        this.mStudyType = instance.mStudyType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ThirdPartyPartnerPanelRequest> getParser() {
        return new APIRequest.ResponseParser<ThirdPartyPartnerPanelRequest>(){

            @Override
            public APINodeList<ThirdPartyPartnerPanelRequest> parseResponse(String response, APIContext context, APIRequest<ThirdPartyPartnerPanelRequest> request, String header) throws APIException.MalformedResponseException {
                return ThirdPartyPartnerPanelRequest.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStudyType {
        VALUE_BRAND_LIFT("BRAND_LIFT"),
        VALUE_PANEL_SALES_ATTRIBUTION("PANEL_SALES_ATTRIBUTION"),
        VALUE_REACH("REACH");

        private String value;

        private EnumStudyType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumStatus {
        VALUE_CREATED("CREATED"),
        VALUE_FAILURE("FAILURE"),
        VALUE_IN_PROGRESS("IN_PROGRESS"),
        VALUE_SCHEDULED("SCHEDULED"),
        VALUE_SUCCESS("SUCCESS");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ThirdPartyPartnerPanelRequest> {
        ThirdPartyPartnerPanelRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"adentities_ids", "country", "created_time", "description", "id", "modified_time", "owner_instance_id", "owner_panel_id", "owner_panel_name", "status", "study_end_time", "study_start_time", "study_type"};

        @Override
        public ThirdPartyPartnerPanelRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ThirdPartyPartnerPanelRequest parseResponse(String response, String header) throws APIException {
            return ThirdPartyPartnerPanelRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ThirdPartyPartnerPanelRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ThirdPartyPartnerPanelRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ThirdPartyPartnerPanelRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ThirdPartyPartnerPanelRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ThirdPartyPartnerPanelRequest>(){

                public ThirdPartyPartnerPanelRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdentitiesIdsField() {
            return this.requestAdentitiesIdsField(true);
        }

        public APIRequestGet requestAdentitiesIdsField(boolean value) {
            this.requestField("adentities_ids", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestModifiedTimeField() {
            return this.requestModifiedTimeField(true);
        }

        public APIRequestGet requestModifiedTimeField(boolean value) {
            this.requestField("modified_time", value);
            return this;
        }

        public APIRequestGet requestOwnerInstanceIdField() {
            return this.requestOwnerInstanceIdField(true);
        }

        public APIRequestGet requestOwnerInstanceIdField(boolean value) {
            this.requestField("owner_instance_id", value);
            return this;
        }

        public APIRequestGet requestOwnerPanelIdField() {
            return this.requestOwnerPanelIdField(true);
        }

        public APIRequestGet requestOwnerPanelIdField(boolean value) {
            this.requestField("owner_panel_id", value);
            return this;
        }

        public APIRequestGet requestOwnerPanelNameField() {
            return this.requestOwnerPanelNameField(true);
        }

        public APIRequestGet requestOwnerPanelNameField(boolean value) {
            this.requestField("owner_panel_name", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStudyEndTimeField() {
            return this.requestStudyEndTimeField(true);
        }

        public APIRequestGet requestStudyEndTimeField(boolean value) {
            this.requestField("study_end_time", value);
            return this;
        }

        public APIRequestGet requestStudyStartTimeField() {
            return this.requestStudyStartTimeField(true);
        }

        public APIRequestGet requestStudyStartTimeField(boolean value) {
            this.requestField("study_start_time", value);
            return this;
        }

        public APIRequestGet requestStudyTypeField() {
            return this.requestStudyTypeField(true);
        }

        public APIRequestGet requestStudyTypeField(boolean value) {
            this.requestField("study_type", value);
            return this;
        }
    }
}

