/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class VideoGroup
extends APINode {
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="disable_reason")
    private String mDisableReason = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ig_profile_ids")
    private List<String> mIgProfileIds = null;
    @SerializedName(value="is_disabled")
    private Boolean mIsDisabled = null;
    @SerializedName(value="is_fb_video_group")
    private Boolean mIsFbVideoGroup = null;
    @SerializedName(value="last_used_time")
    private String mLastUsedTime = null;
    @SerializedName(value="length")
    private Double mLength = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="page_ids")
    private List<String> mPageIds = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="placements")
    private List<String> mPlacements = null;
    @SerializedName(value="video_group_types")
    private List<String> mVideoGroupTypes = null;
    @SerializedName(value="videos")
    private List<String> mVideos = null;
    @SerializedName(value="views")
    private Long mViews = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoGroup loadJSON(String json, APIContext context, String header) {
        VideoGroup videoGroup = (VideoGroup)VideoGroup.getGson().fromJson(json, VideoGroup.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoGroup.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoGroup.context = context;
        videoGroup.rawValue = json;
        videoGroup.header = header;
        return videoGroup;
    }

    public static APINodeList<VideoGroup> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoGroup> videoGroups = new APINodeList<VideoGroup>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoGroups.add(VideoGroup.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoGroups;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoGroups.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoGroups.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoGroups.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoGroups.add(VideoGroup.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoGroups.add(VideoGroup.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoGroups.add(VideoGroup.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoGroups;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoGroups.add(VideoGroup.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoGroups;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoGroups.add(VideoGroup.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoGroups;
                }
                videoGroups.clear();
                videoGroups.add(VideoGroup.loadJSON(json, context, header));
                return videoGroups;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoGroup.getGson().toJson((Object)this);
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public VideoGroup setFieldCreatedTime(String value) {
        this.mCreatedTime = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public VideoGroup setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldDisableReason() {
        return this.mDisableReason;
    }

    public VideoGroup setFieldDisableReason(String value) {
        this.mDisableReason = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public VideoGroup setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public List<String> getFieldIgProfileIds() {
        return this.mIgProfileIds;
    }

    public VideoGroup setFieldIgProfileIds(List<String> value) {
        this.mIgProfileIds = value;
        return this;
    }

    public Boolean getFieldIsDisabled() {
        return this.mIsDisabled;
    }

    public VideoGroup setFieldIsDisabled(Boolean value) {
        this.mIsDisabled = value;
        return this;
    }

    public Boolean getFieldIsFbVideoGroup() {
        return this.mIsFbVideoGroup;
    }

    public VideoGroup setFieldIsFbVideoGroup(Boolean value) {
        this.mIsFbVideoGroup = value;
        return this;
    }

    public String getFieldLastUsedTime() {
        return this.mLastUsedTime;
    }

    public VideoGroup setFieldLastUsedTime(String value) {
        this.mLastUsedTime = value;
        return this;
    }

    public Double getFieldLength() {
        return this.mLength;
    }

    public VideoGroup setFieldLength(Double value) {
        this.mLength = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public VideoGroup setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public VideoGroup setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public List<String> getFieldPageIds() {
        return this.mPageIds;
    }

    public VideoGroup setFieldPageIds(List<String> value) {
        this.mPageIds = value;
        return this;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public VideoGroup setFieldPicture(String value) {
        this.mPicture = value;
        return this;
    }

    public List<String> getFieldPlacements() {
        return this.mPlacements;
    }

    public VideoGroup setFieldPlacements(List<String> value) {
        this.mPlacements = value;
        return this;
    }

    public List<String> getFieldVideoGroupTypes() {
        return this.mVideoGroupTypes;
    }

    public VideoGroup setFieldVideoGroupTypes(List<String> value) {
        this.mVideoGroupTypes = value;
        return this;
    }

    public List<String> getFieldVideos() {
        return this.mVideos;
    }

    public VideoGroup setFieldVideos(List<String> value) {
        this.mVideos = value;
        return this;
    }

    public Long getFieldViews() {
        return this.mViews;
    }

    public VideoGroup setFieldViews(Long value) {
        this.mViews = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoGroup copyFrom(VideoGroup instance) {
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mDisableReason = instance.mDisableReason;
        this.mId = instance.mId;
        this.mIgProfileIds = instance.mIgProfileIds;
        this.mIsDisabled = instance.mIsDisabled;
        this.mIsFbVideoGroup = instance.mIsFbVideoGroup;
        this.mLastUsedTime = instance.mLastUsedTime;
        this.mLength = instance.mLength;
        this.mName = instance.mName;
        this.mPageId = instance.mPageId;
        this.mPageIds = instance.mPageIds;
        this.mPicture = instance.mPicture;
        this.mPlacements = instance.mPlacements;
        this.mVideoGroupTypes = instance.mVideoGroupTypes;
        this.mVideos = instance.mVideos;
        this.mViews = instance.mViews;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoGroup> getParser() {
        return new APIRequest.ResponseParser<VideoGroup>(){

            @Override
            public APINodeList<VideoGroup> parseResponse(String response, APIContext context, APIRequest<VideoGroup> request, String header) throws APIException.MalformedResponseException {
                return VideoGroup.parseResponse(response, context, request, header);
            }
        };
    }
}

