/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class VideoStats
extends APINode {
    @SerializedName(value="aggregate")
    private List<Map<String, Object>> mAggregate = null;
    @SerializedName(value="error")
    private String mError = null;
    @SerializedName(value="metadata")
    private List<Map<String, Object>> mMetadata = null;
    @SerializedName(value="time_series")
    private List<Map<String, List<Object>>> mTimeSeries = null;
    @SerializedName(value="totals")
    private List<Map<String, Object>> mTotals = null;
    @SerializedName(value="x_axis_breakdown")
    private List<List<Map<String, Object>>> mXAxisBreakdown = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static VideoStats loadJSON(String json, APIContext context, String header) {
        VideoStats videoStats = (VideoStats)VideoStats.getGson().fromJson(json, VideoStats.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoStats.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoStats.context = context;
        videoStats.rawValue = json;
        videoStats.header = header;
        return videoStats;
    }

    public static APINodeList<VideoStats> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoStats> videoStatss = new APINodeList<VideoStats>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoStatss.add(VideoStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoStatss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoStatss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoStatss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoStatss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoStatss.add(VideoStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoStatss.add(VideoStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoStatss.add(VideoStats.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoStatss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoStatss.add(VideoStats.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoStatss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoStatss.add(VideoStats.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoStatss;
                }
                videoStatss.clear();
                videoStatss.add(VideoStats.loadJSON(json, context, header));
                return videoStatss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoStats.getGson().toJson((Object)this);
    }

    public List<Map<String, Object>> getFieldAggregate() {
        return this.mAggregate;
    }

    public VideoStats setFieldAggregate(List<Map<String, Object>> value) {
        this.mAggregate = value;
        return this;
    }

    public String getFieldError() {
        return this.mError;
    }

    public VideoStats setFieldError(String value) {
        this.mError = value;
        return this;
    }

    public List<Map<String, Object>> getFieldMetadata() {
        return this.mMetadata;
    }

    public VideoStats setFieldMetadata(List<Map<String, Object>> value) {
        this.mMetadata = value;
        return this;
    }

    public List<Map<String, List<Object>>> getFieldTimeSeries() {
        return this.mTimeSeries;
    }

    public VideoStats setFieldTimeSeries(List<Map<String, List<Object>>> value) {
        this.mTimeSeries = value;
        return this;
    }

    public List<Map<String, Object>> getFieldTotals() {
        return this.mTotals;
    }

    public VideoStats setFieldTotals(List<Map<String, Object>> value) {
        this.mTotals = value;
        return this;
    }

    public List<List<Map<String, Object>>> getFieldXAxisBreakdown() {
        return this.mXAxisBreakdown;
    }

    public VideoStats setFieldXAxisBreakdown(List<List<Map<String, Object>>> value) {
        this.mXAxisBreakdown = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoStats copyFrom(VideoStats instance) {
        this.mAggregate = instance.mAggregate;
        this.mError = instance.mError;
        this.mMetadata = instance.mMetadata;
        this.mTimeSeries = instance.mTimeSeries;
        this.mTotals = instance.mTotals;
        this.mXAxisBreakdown = instance.mXAxisBreakdown;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoStats> getParser() {
        return new APIRequest.ResponseParser<VideoStats>(){

            @Override
            public APINodeList<VideoStats> parseResponse(String response, APIContext context, APIRequest<VideoStats> request, String header) throws APIException.MalformedResponseException {
                return VideoStats.parseResponse(response, context, request, header);
            }
        };
    }
}

