/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class WebsiteCreativeAssetSuggestions
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="extraction_status")
    private String mExtractionStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="link_url")
    private String mLinkUrl = null;
    protected static Gson gson = null;

    WebsiteCreativeAssetSuggestions() {
    }

    public WebsiteCreativeAssetSuggestions(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WebsiteCreativeAssetSuggestions(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WebsiteCreativeAssetSuggestions fetch() throws APIException {
        WebsiteCreativeAssetSuggestions newInstance = WebsiteCreativeAssetSuggestions.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WebsiteCreativeAssetSuggestions fetchById(Long id, APIContext context) throws APIException {
        return WebsiteCreativeAssetSuggestions.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WebsiteCreativeAssetSuggestions> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WebsiteCreativeAssetSuggestions.fetchByIdAsync(id.toString(), context);
    }

    public static WebsiteCreativeAssetSuggestions fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WebsiteCreativeAssetSuggestions> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WebsiteCreativeAssetSuggestions> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WebsiteCreativeAssetSuggestions>(context, "", "/", "GET", WebsiteCreativeAssetSuggestions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WebsiteCreativeAssetSuggestions>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WebsiteCreativeAssetSuggestions>(context, "", "/", "GET", WebsiteCreativeAssetSuggestions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WebsiteCreativeAssetSuggestions loadJSON(String json, APIContext context, String header) {
        WebsiteCreativeAssetSuggestions websiteCreativeAssetSuggestions = (WebsiteCreativeAssetSuggestions)WebsiteCreativeAssetSuggestions.getGson().fromJson(json, WebsiteCreativeAssetSuggestions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(websiteCreativeAssetSuggestions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        websiteCreativeAssetSuggestions.context = context;
        websiteCreativeAssetSuggestions.rawValue = json;
        websiteCreativeAssetSuggestions.header = header;
        return websiteCreativeAssetSuggestions;
    }

    public static APINodeList<WebsiteCreativeAssetSuggestions> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WebsiteCreativeAssetSuggestions> websiteCreativeAssetSuggestionss = new APINodeList<WebsiteCreativeAssetSuggestions>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        websiteCreativeAssetSuggestionss.add(WebsiteCreativeAssetSuggestions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return websiteCreativeAssetSuggestionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            websiteCreativeAssetSuggestionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        websiteCreativeAssetSuggestionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            websiteCreativeAssetSuggestionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            websiteCreativeAssetSuggestionss.add(WebsiteCreativeAssetSuggestions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                websiteCreativeAssetSuggestionss.add(WebsiteCreativeAssetSuggestions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            websiteCreativeAssetSuggestionss.add(WebsiteCreativeAssetSuggestions.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return websiteCreativeAssetSuggestionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        websiteCreativeAssetSuggestionss.add(WebsiteCreativeAssetSuggestions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return websiteCreativeAssetSuggestionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        websiteCreativeAssetSuggestionss.add(WebsiteCreativeAssetSuggestions.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return websiteCreativeAssetSuggestionss;
                }
                websiteCreativeAssetSuggestionss.clear();
                websiteCreativeAssetSuggestionss.add(WebsiteCreativeAssetSuggestions.loadJSON(json, context, header));
                return websiteCreativeAssetSuggestionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WebsiteCreativeAssetSuggestions.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public String getFieldExtractionStatus() {
        return this.mExtractionStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLinkUrl() {
        return this.mLinkUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WebsiteCreativeAssetSuggestions copyFrom(WebsiteCreativeAssetSuggestions instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mExtractionStatus = instance.mExtractionStatus;
        this.mId = instance.mId;
        this.mLinkUrl = instance.mLinkUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WebsiteCreativeAssetSuggestions> getParser() {
        return new APIRequest.ResponseParser<WebsiteCreativeAssetSuggestions>(){

            @Override
            public APINodeList<WebsiteCreativeAssetSuggestions> parseResponse(String response, APIContext context, APIRequest<WebsiteCreativeAssetSuggestions> request, String header) throws APIException.MalformedResponseException {
                return WebsiteCreativeAssetSuggestions.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<WebsiteCreativeAssetSuggestions> {
        WebsiteCreativeAssetSuggestions lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_id", "extraction_status", "id", "link_url"};

        @Override
        public WebsiteCreativeAssetSuggestions getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WebsiteCreativeAssetSuggestions parseResponse(String response, String header) throws APIException {
            return WebsiteCreativeAssetSuggestions.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WebsiteCreativeAssetSuggestions execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WebsiteCreativeAssetSuggestions execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WebsiteCreativeAssetSuggestions> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WebsiteCreativeAssetSuggestions> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WebsiteCreativeAssetSuggestions>(){

                public WebsiteCreativeAssetSuggestions apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGet requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGet requestExtractionStatusField() {
            return this.requestExtractionStatusField(true);
        }

        public APIRequestGet requestExtractionStatusField(boolean value) {
            this.requestField("extraction_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLinkUrlField() {
            return this.requestLinkUrlField(true);
        }

        public APIRequestGet requestLinkUrlField(boolean value) {
            this.requestField("link_url", value);
            return this;
        }
    }
}

