/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.paramnames;

import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

class ParameterNamesAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    ParameterNamesAnnotationIntrospector() {
    }

    public PropertyName findNameForDeserialization(Annotated annotated) {
        return null;
    }

    public String findImplicitPropertyName(AnnotatedMember m) {
        if (m instanceof AnnotatedParameter) {
            return this.findParameterName((AnnotatedParameter)m);
        }
        return null;
    }

    private String findParameterName(AnnotatedParameter annotatedParameter) {
        AnnotatedWithParams owner = annotatedParameter.getOwner();
        if (owner instanceof AnnotatedConstructor) {
            return this.findParameterName((AnnotatedConstructor)owner, annotatedParameter.getIndex());
        }
        if (owner instanceof AnnotatedMethod) {
            return this.findParameterName((AnnotatedMethod)owner, annotatedParameter.getIndex());
        }
        return null;
    }

    private String findParameterName(AnnotatedConstructor annotatedConstructor, int parameterIndex) {
        Constructor constructor = annotatedConstructor.getAnnotated();
        return this.findParameterName(constructor.getParameters(), parameterIndex);
    }

    private String findParameterName(AnnotatedMethod annotatedMethod, int parameterIndex) {
        Method method = annotatedMethod.getAnnotated();
        return this.findParameterName(method.getParameters(), parameterIndex);
    }

    private String findParameterName(Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        return parameter.isNamePresent() ? parameter.getName() : null;
    }
}

