/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.FileNotFoundException;
import java.io.IOException;
import net.lingala.zip4j.NativeStorage;
import net.lingala.zip4j.io.inputstream.SplitInputStream;

public class ZipStandardSplitInputStream
extends SplitInputStream {
    private int lastSplitZipFileNumber;

    public ZipStandardSplitInputStream(NativeStorage zipFile, boolean isSplitZipArchive, int lastSplitZipFileNumber) throws FileNotFoundException {
        super(zipFile, isSplitZipArchive, lastSplitZipFileNumber);
        this.lastSplitZipFileNumber = lastSplitZipFileNumber;
    }

    @Override
    protected NativeStorage getNextSplitFile(int zipFileIndex) throws IOException {
        if (zipFileIndex == this.lastSplitZipFileNumber) {
            return this.zipFile;
        }
        String currZipFileNameWithPath = this.zipFile.getName();
        String extensionSubString = ".z0";
        if (zipFileIndex >= 9) {
            extensionSubString = ".z";
        }
        return this.zipFile.open(currZipFileNameWithPath.substring(0, currZipFileNameWithPath.lastIndexOf(".")) + extensionSubString + (zipFileIndex + 1));
    }
}

