/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.security;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.security.Authenticator;
import java.util.Arrays;
import java.util.List;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.ImmutableList;

public class BasicAuthenticator
implements Authenticator {
    private final List<BasicCredentials> credentials;

    public BasicAuthenticator(List<BasicCredentials> credentials) {
        this.credentials = credentials;
    }

    public BasicAuthenticator(BasicCredentials ... credentials) {
        this.credentials = Arrays.asList(credentials);
    }

    public BasicAuthenticator(String username, String password) {
        this(new BasicCredentials(username, password));
    }

    @Override
    public boolean authenticate(Request request) {
        ImmutableList<String> headerValues = FluentIterable.from(this.credentials).transform(new Function<BasicCredentials, String>(){

            @Override
            public String apply(BasicCredentials input) {
                return input.asAuthorizationHeaderValue();
            }
        }).toList();
        return request.containsHeader("Authorization") && headerValues.contains(request.header("Authorization").firstValue());
    }
}

