/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.crypto.agreement.kdf;

import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1EncodableVector;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.DERNull;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.DEROctetString;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.DERSequence;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.DERTaggedObject;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.DataLengthException;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.DerivationParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.Digest;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.DigestDerivationFunction;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.KDFParameters;
import hadoopcryptoledger.shade.org.bouncycastle.util.Pack;
import java.io.IOException;

public class ECDHKEKGenerator
implements DigestDerivationFunction {
    private DigestDerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    public void init(DerivationParameters derivationParameters) {
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        this.algorithm = dHKDFParameters.getAlgorithm();
        this.keySize = dHKDFParameters.getKeySize();
        this.z = dHKDFParameters.getZ();
    }

    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("output buffer too small");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE));
        aSN1EncodableVector.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(aSN1EncodableVector).getEncoded("DER")));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to initialise kdf: " + iOException.getMessage());
        }
        return this.kdf.generateBytes(byArray, n, n2);
    }
}

