/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.crypto.generators;

import hadoopcryptoledger.shade.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.KeyGenerationParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.DHParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ElGamalParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

