/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.crypto.tls;

import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1Primitive;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[0]);
    protected hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[] certificateList;

    public Certificate(hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[] certificateArray) {
        if (certificateArray == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateArray;
    }

    public hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate getCertificateAt(int n) {
        return this.certificateList[n];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n;
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n2 = 0;
        for (n = 0; n < this.certificateList.length; ++n) {
            byArray = this.certificateList[n].getEncoded("DER");
            vector.addElement(byArray);
            n2 += byArray.length + 3;
        }
        TlsUtils.checkUint24(n2);
        TlsUtils.writeUint24(n2, outputStream);
        for (n = 0; n < vector.size(); ++n) {
            byArray = (byte[])vector.elementAt(n);
            TlsUtils.writeOpaque24(byArray, outputStream);
        }
    }

    public static Certificate parse(InputStream inputStream) throws IOException {
        Object[] objectArray;
        int n = TlsUtils.readUint24(inputStream);
        if (n == 0) {
            return EMPTY_CHAIN;
        }
        byte[] byArray = TlsUtils.readFully(n, inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate> vector = new Vector<hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate>();
        while (byteArrayInputStream.available() > 0) {
            objectArray = TlsUtils.readOpaque24(byteArrayInputStream);
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(objectArray);
            vector.addElement(hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Primitive));
        }
        objectArray = new hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (byte)((hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate)vector.elementAt(i));
        }
        return new Certificate((hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[])objectArray);
    }

    protected hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[] cloneCertificateList() {
        hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[] certificateArray = new hadoopcryptoledger.shade.org.bouncycastle.asn1.x509.Certificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, certificateArray, 0, certificateArray.length);
        return certificateArray;
    }
}

