/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.crypto.tls;

import hadoopcryptoledger.shade.org.bouncycastle.crypto.agreement.DHStandardGroups;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.DHParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.tls.TlsDHVerifier;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsDHVerifier
implements TlsDHVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHParameters dHParameters) {
        DEFAULT_GROUPS.addElement(dHParameters);
    }

    public DefaultTlsDHVerifier() {
        this(2048);
    }

    public DefaultTlsDHVerifier(int n) {
        this(DEFAULT_GROUPS, n);
    }

    public DefaultTlsDHVerifier(Vector vector, int n) {
        this.groups = vector;
        this.minimumPrimeBits = n;
    }

    public boolean accept(DHParameters dHParameters) {
        return this.checkMinimumPrimeBits(dHParameters) && this.checkGroup(dHParameters);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHParameters dHParameters, DHParameters dHParameters2) {
        return dHParameters == dHParameters2 || this.areParametersEqual(dHParameters.getP(), dHParameters2.getP()) && this.areParametersEqual(dHParameters.getG(), dHParameters2.getG());
    }

    protected boolean areParametersEqual(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger == bigInteger2 || bigInteger.equals(bigInteger2);
    }

    protected boolean checkGroup(DHParameters dHParameters) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(dHParameters, (DHParameters)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(DHParameters dHParameters) {
        return dHParameters.getP().bitLength() >= this.getMinimumPrimeBits();
    }

    static {
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe8192);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_1536);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
    }
}

