/*
 * Decompiled with CFR 0.152.
 */
package hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.asymmetric.ec;

import hadoopcryptoledger.shade.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import hadoopcryptoledger.shade.org.bouncycastle.asn1.x9.X9ECParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.CryptoServicesRegistrar;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ECDomainParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import hadoopcryptoledger.shade.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import hadoopcryptoledger.shade.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import hadoopcryptoledger.shade.org.bouncycastle.jce.provider.BouncyCastleProvider;
import hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import hadoopcryptoledger.shade.org.bouncycastle.math.ec.ECCurve;
import hadoopcryptoledger.shade.org.bouncycastle.math.ec.ECPoint;
import hadoopcryptoledger.shade.org.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import java.util.Map;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String string) {
        super(string);
    }

    public static class EC
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public EC(String string, ProviderConfiguration providerConfiguration) {
            super(string);
            this.algorithm = string;
            this.configuration = providerConfiguration;
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(n));
            if (eCGenParameterSpec == null) {
                throw new InvalidParameterException("unknown key size.");
            }
            try {
                this.initialize(eCGenParameterSpec, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException("key size not configurable.");
            }
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec == null) {
                hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = this.configuration.getEcImplicitlyCa();
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                this.ecParams = null;
                this.param = this.createKeyGenParamsBC(eCParameterSpec, secureRandom);
            } else if (algorithmParameterSpec instanceof hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECParameterSpec) {
                this.ecParams = algorithmParameterSpec;
                this.param = this.createKeyGenParamsBC((hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECParameterSpec)algorithmParameterSpec, secureRandom);
            } else if (algorithmParameterSpec instanceof ECParameterSpec) {
                this.ecParams = algorithmParameterSpec;
                this.param = this.createKeyGenParamsJCE((ECParameterSpec)algorithmParameterSpec, secureRandom);
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                this.initializeNamedCurve(((ECGenParameterSpec)algorithmParameterSpec).getName(), secureRandom);
            } else if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
                this.initializeNamedCurve(((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName(), secureRandom);
            } else {
                String string = ECUtil.getNameFrom(algorithmParameterSpec);
                if (string != null) {
                    this.initializeNamedCurve(string, secureRandom);
                } else {
                    throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + algorithmParameterSpec);
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, new SecureRandom());
            }
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            if (this.ecParams instanceof hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECParameterSpec) {
                hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
                BCECPublicKey bCECPublicKey = new BCECPublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec, this.configuration);
                return new KeyPair(bCECPublicKey, new BCECPrivateKey(this.algorithm, eCPrivateKeyParameters, bCECPublicKey, eCParameterSpec, this.configuration));
            }
            if (this.ecParams == null) {
                return new KeyPair(new BCECPublicKey(this.algorithm, eCPublicKeyParameters, this.configuration), new BCECPrivateKey(this.algorithm, eCPrivateKeyParameters, this.configuration));
            }
            ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
            BCECPublicKey bCECPublicKey = new BCECPublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec, this.configuration);
            return new KeyPair(bCECPublicKey, new BCECPrivateKey(this.algorithm, eCPrivateKeyParameters, bCECPublicKey, eCParameterSpec, this.configuration));
        }

        protected ECKeyGenerationParameters createKeyGenParamsBC(hadoopcryptoledger.shade.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec, SecureRandom secureRandom) {
            return new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH()), secureRandom);
        }

        protected ECKeyGenerationParameters createKeyGenParamsJCE(ECParameterSpec eCParameterSpec, SecureRandom secureRandom) {
            Object object;
            if (eCParameterSpec instanceof ECNamedCurveSpec && (object = ECUtils.getDomainParametersFromName(((ECNamedCurveSpec)eCParameterSpec).getName())) != null) {
                ECDomainParameters eCDomainParameters = new ECDomainParameters(((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getG(), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH());
                return new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            }
            object = EC5Util.convertCurve(eCParameterSpec.getCurve());
            ECPoint eCPoint = EC5Util.convertPoint((ECCurve)object, eCParameterSpec.getGenerator());
            BigInteger bigInteger = eCParameterSpec.getOrder();
            BigInteger bigInteger2 = BigInteger.valueOf(eCParameterSpec.getCofactor());
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)object, eCPoint, bigInteger, bigInteger2);
            return new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
        }

        protected ECNamedCurveSpec createNamedCurveSpec(String string) throws InvalidAlgorithmParameterException {
            Map map;
            X9ECParameters x9ECParameters = ECUtils.getDomainParametersFromName(string);
            if (x9ECParameters == null) {
                try {
                    x9ECParameters = ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(string));
                    if (x9ECParameters == null && (x9ECParameters = (X9ECParameters)(map = this.configuration.getAdditionalECParameters()).get(new ASN1ObjectIdentifier(string))) == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve OID: " + string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
                }
            }
            map = null;
            return new ECNamedCurveSpec(string, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), (byte[])map);
        }

        protected void initializeNamedCurve(String string, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            ECNamedCurveSpec eCNamedCurveSpec = this.createNamedCurveSpec(string);
            this.ecParams = eCNamedCurveSpec;
            this.param = this.createKeyGenParamsJCE(eCNamedCurveSpec, secureRandom);
        }

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV", BouncyCastleProvider.CONFIGURATION);
        }
    }
}

