/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinAuxPOW;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinAuxPOWBlockHeader;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinAuxPOWBranch;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinScriptWitness;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinScriptWitnessItem;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransaction;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransactionInput;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransactionOutput;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.ethereum.format.common.EthereumUtil;

public class BitcoinBlockReader {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockReader.class.getName());
    private int maxSizeBitcoinBlock = 0;
    private boolean useDirectBuffer = false;
    private boolean readAuxPow = false;
    private boolean filterSpecificMagic = false;
    private byte[][] specificMagicByteArray;
    private ByteBuffer preAllocatedDirectByteBuffer;
    private InputStream bin;

    public BitcoinBlockReader(InputStream in, int maxSizeBitcoinBlock, int bufferSize, byte[][] specificMagicByteArray, boolean useDirectBuffer) {
        this(in, maxSizeBitcoinBlock, bufferSize, specificMagicByteArray, useDirectBuffer, false);
    }

    public BitcoinBlockReader(InputStream in, int maxSizeBitcoinBlock, int bufferSize, byte[][] specificMagicByteArray, boolean useDirectBuffer, boolean readAuxPow) {
        this.maxSizeBitcoinBlock = maxSizeBitcoinBlock;
        this.specificMagicByteArray = specificMagicByteArray;
        this.useDirectBuffer = useDirectBuffer;
        if (specificMagicByteArray != null) {
            this.filterSpecificMagic = true;
        }
        this.bin = bufferSize == 0 ? in : new BufferedInputStream(in, bufferSize);
        if (this.useDirectBuffer) {
            this.preAllocatedDirectByteBuffer = ByteBuffer.allocateDirect(this.maxSizeBitcoinBlock);
        }
        this.readAuxPow = readAuxPow;
    }

    public void seekBlockStart() throws BitcoinBlockReadException {
        if (!this.filterSpecificMagic) {
            throw new BitcoinBlockReadException("Error: Cannot seek to a block start, because no magic(s) are defined.");
        }
        this.findMagic();
        this.checkFullBlock();
    }

    public BitcoinBlock readBlock() throws BitcoinBlockReadException {
        ByteBuffer rawByteBuffer = this.readRawBlock();
        if (rawByteBuffer == null) {
            return null;
        }
        byte[] currentMagicNo = new byte[4];
        byte[] currentBits = new byte[4];
        byte[] currentHashMerkleRoot = new byte[32];
        byte[] currentHashPrevBlock = new byte[32];
        rawByteBuffer.get(currentMagicNo, 0, 4);
        int currentBlockSize = rawByteBuffer.getInt();
        int currentVersion = rawByteBuffer.getInt();
        rawByteBuffer.get(currentHashPrevBlock, 0, 32);
        rawByteBuffer.get(currentHashMerkleRoot, 0, 32);
        int currentTime = rawByteBuffer.getInt();
        rawByteBuffer.get(currentBits, 0, 4);
        int currentNonce = rawByteBuffer.getInt();
        BitcoinAuxPOW auxPOW = this.parseAuxPow(rawByteBuffer);
        long currentTransactionCounter = BitcoinUtil.convertVarIntByteBufferToLong(rawByteBuffer);
        List<BitcoinTransaction> allBlockTransactions = this.parseTransactions(rawByteBuffer, currentTransactionCounter);
        if ((long)allBlockTransactions.size() != currentTransactionCounter) {
            throw new BitcoinBlockReadException("Error: Number of Transactions (" + allBlockTransactions.size() + ") does not correspond to transaction counter in block (" + currentTransactionCounter + ")");
        }
        BitcoinBlock result = new BitcoinBlock();
        result.setMagicNo(currentMagicNo);
        result.setBlockSize(currentBlockSize);
        result.setVersion(currentVersion);
        result.setTime(currentTime);
        result.setBits(currentBits);
        result.setNonce(currentNonce);
        result.setTransactionCounter(currentTransactionCounter);
        result.setHashPrevBlock(currentHashPrevBlock);
        result.setHashMerkleRoot(currentHashMerkleRoot);
        result.setAuxPOW(auxPOW);
        result.setTransactions(allBlockTransactions);
        return result;
    }

    public BitcoinAuxPOW parseAuxPow(ByteBuffer rawByteBuffer) {
        if (!this.readAuxPow) {
            return null;
        }
        rawByteBuffer.mark();
        int currentVersion = rawByteBuffer.getInt();
        byte[] currentInCounterVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
        byte[] currentTransactionInputPrevTransactionHash = new byte[32];
        rawByteBuffer.get(currentTransactionInputPrevTransactionHash, 0, 32);
        byte[] prevTxOutIdx = new byte[4];
        rawByteBuffer.get(prevTxOutIdx, 0, 4);
        rawByteBuffer.reset();
        byte[] expectedPrevTransactionHash = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] expectedPrevOutIdx = new byte[]{-1, -1, -1, -1};
        if (!Arrays.equals(prevTxOutIdx, expectedPrevOutIdx) || !Arrays.equals(currentTransactionInputPrevTransactionHash, expectedPrevTransactionHash)) {
            return null;
        }
        currentVersion = rawByteBuffer.getInt();
        currentInCounterVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
        long currentNoOfInputs = BitcoinUtil.getVarInt(currentInCounterVarInt);
        List<BitcoinTransactionInput> currentTransactionInput = this.parseTransactionInputs(rawByteBuffer, currentNoOfInputs);
        byte[] currentOutCounterVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
        long currentNoOfOutput = BitcoinUtil.getVarInt(currentOutCounterVarInt);
        List<BitcoinTransactionOutput> currentTransactionOutput = this.parseTransactionOutputs(rawByteBuffer, currentNoOfOutput);
        int lockTime = rawByteBuffer.getInt();
        BitcoinTransaction coinbaseTransaction = new BitcoinTransaction(currentVersion, currentInCounterVarInt, currentTransactionInput, currentOutCounterVarInt, currentTransactionOutput, lockTime);
        byte[] coinbaseParentBlockHeaderHash = new byte[32];
        rawByteBuffer.get(coinbaseParentBlockHeaderHash, 0, 32);
        BitcoinAuxPOWBranch coinbaseBranch = this.parseAuxPOWBranch(rawByteBuffer);
        BitcoinAuxPOWBranch auxChainBranch = this.parseAuxPOWBranch(rawByteBuffer);
        byte[] parentBlockBits = new byte[4];
        byte[] parentBlockHashMerkleRoot = new byte[32];
        byte[] parentBlockHashPrevBlock = new byte[32];
        int parentBlockVersion = rawByteBuffer.getInt();
        rawByteBuffer.get(parentBlockHashPrevBlock, 0, 32);
        rawByteBuffer.get(parentBlockHashMerkleRoot, 0, 32);
        int parentBlockTime = rawByteBuffer.getInt();
        rawByteBuffer.get(parentBlockBits, 0, 4);
        int parentBlockNonce = rawByteBuffer.getInt();
        BitcoinAuxPOWBlockHeader parentBlockheader = new BitcoinAuxPOWBlockHeader(parentBlockVersion, parentBlockHashPrevBlock, parentBlockHashMerkleRoot, parentBlockTime, parentBlockBits, parentBlockNonce);
        return new BitcoinAuxPOW(currentVersion, coinbaseTransaction, coinbaseParentBlockHeaderHash, coinbaseBranch, auxChainBranch, parentBlockheader);
    }

    public BitcoinAuxPOWBranch parseAuxPOWBranch(ByteBuffer rawByteBuffer) {
        byte[] noOfLinksVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
        long currentNoOfLinks = BitcoinUtil.getVarInt(noOfLinksVarInt);
        ArrayList<byte[]> links = new ArrayList<byte[]>((int)currentNoOfLinks);
        int i = 0;
        while ((long)i < currentNoOfLinks) {
            byte[] currentLink = new byte[32];
            rawByteBuffer.get(currentLink, 0, 32);
            links.add(currentLink);
            ++i;
        }
        byte[] branchSideBitmask = new byte[4];
        rawByteBuffer.get(branchSideBitmask, 0, 4);
        return new BitcoinAuxPOWBranch(noOfLinksVarInt, links, branchSideBitmask);
    }

    public List<BitcoinTransaction> parseTransactions(ByteBuffer rawByteBuffer, long noOfTransactions) {
        ArrayList<BitcoinTransaction> resultTransactions = new ArrayList<BitcoinTransaction>((int)noOfTransactions);
        int k = 0;
        while ((long)k < noOfTransactions) {
            ArrayList<BitcoinScriptWitnessItem> currentListOfTransactionSegwits;
            int currentVersion = rawByteBuffer.getInt();
            byte[] currentInCounterVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
            long currentNoOfInputs = BitcoinUtil.getVarInt(currentInCounterVarInt);
            boolean segwit = false;
            byte marker = 1;
            byte flag = 0;
            if (currentNoOfInputs == 0L) {
                rawByteBuffer.mark();
                byte segwitFlag = rawByteBuffer.get();
                if (segwitFlag != 0) {
                    segwit = true;
                    marker = 0;
                    flag = segwitFlag;
                    currentInCounterVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
                    currentNoOfInputs = BitcoinUtil.getVarInt(currentInCounterVarInt);
                } else {
                    LOG.warn((Object)"It seems a block with 0 transaction inputs was found");
                    rawByteBuffer.reset();
                }
            }
            List<BitcoinTransactionInput> currentTransactionInput = this.parseTransactionInputs(rawByteBuffer, currentNoOfInputs);
            byte[] currentOutCounterVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
            long currentNoOfOutput = BitcoinUtil.getVarInt(currentOutCounterVarInt);
            List<BitcoinTransactionOutput> currentTransactionOutput = this.parseTransactionOutputs(rawByteBuffer, currentNoOfOutput);
            if (segwit) {
                currentListOfTransactionSegwits = new ArrayList<BitcoinScriptWitnessItem>();
                int i = 0;
                while ((long)i < currentNoOfInputs) {
                    byte[] currentWitnessCounterVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
                    long currentNoOfWitnesses = BitcoinUtil.getVarInt(currentWitnessCounterVarInt);
                    ArrayList<BitcoinScriptWitness> currentTransactionSegwit = new ArrayList<BitcoinScriptWitness>((int)currentNoOfWitnesses);
                    for (int j = 0; j < (int)currentNoOfWitnesses; ++j) {
                        byte[] currentTransactionSegwitScriptLength = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
                        long currentTransactionSegwitScriptSize = BitcoinUtil.getVarInt(currentTransactionSegwitScriptLength);
                        int currentTransactionSegwitScriptSizeInt = (int)currentTransactionSegwitScriptSize;
                        byte[] currentTransactionInSegwitScript = new byte[currentTransactionSegwitScriptSizeInt];
                        rawByteBuffer.get(currentTransactionInSegwitScript, 0, currentTransactionSegwitScriptSizeInt);
                        currentTransactionSegwit.add(new BitcoinScriptWitness(currentTransactionSegwitScriptLength, currentTransactionInSegwitScript));
                    }
                    currentListOfTransactionSegwits.add(new BitcoinScriptWitnessItem(currentWitnessCounterVarInt, currentTransactionSegwit));
                    ++i;
                }
            } else {
                currentListOfTransactionSegwits = new ArrayList();
            }
            int currentTransactionLockTime = rawByteBuffer.getInt();
            resultTransactions.add(new BitcoinTransaction(marker, flag, currentVersion, currentInCounterVarInt, currentTransactionInput, currentOutCounterVarInt, currentTransactionOutput, currentListOfTransactionSegwits, currentTransactionLockTime));
            ++k;
        }
        return resultTransactions;
    }

    public List<BitcoinTransactionInput> parseTransactionInputs(ByteBuffer rawByteBuffer, long noOfTransactionInputs) {
        ArrayList<BitcoinTransactionInput> currentTransactionInput = new ArrayList<BitcoinTransactionInput>((int)noOfTransactionInputs);
        int i = 0;
        while ((long)i < noOfTransactionInputs) {
            byte[] currentTransactionInputPrevTransactionHash = new byte[32];
            rawByteBuffer.get(currentTransactionInputPrevTransactionHash, 0, 32);
            long currentTransactionInputPrevTxOutIdx = BitcoinUtil.convertSignedIntToUnsigned(rawByteBuffer.getInt());
            byte[] currentTransactionTxInScriptLengthVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
            long currentTransactionTxInScriptSize = BitcoinUtil.getVarInt(currentTransactionTxInScriptLengthVarInt);
            int currentTransactionTxInScriptSizeInt = (int)currentTransactionTxInScriptSize;
            byte[] currentTransactionInScript = new byte[currentTransactionTxInScriptSizeInt];
            rawByteBuffer.get(currentTransactionInScript, 0, currentTransactionTxInScriptSizeInt);
            long currentTransactionInputSeqNo = BitcoinUtil.convertSignedIntToUnsigned(rawByteBuffer.getInt());
            currentTransactionInput.add(new BitcoinTransactionInput(currentTransactionInputPrevTransactionHash, currentTransactionInputPrevTxOutIdx, currentTransactionTxInScriptLengthVarInt, currentTransactionInScript, currentTransactionInputSeqNo));
            ++i;
        }
        return currentTransactionInput;
    }

    public List<BitcoinTransactionOutput> parseTransactionOutputs(ByteBuffer rawByteBuffer, long noOfTransactionOutputs) {
        ArrayList<BitcoinTransactionOutput> currentTransactionOutput = new ArrayList<BitcoinTransactionOutput>((int)noOfTransactionOutputs);
        int i = 0;
        while ((long)i < noOfTransactionOutputs) {
            byte[] currentTransactionOutputValueArray = new byte[8];
            rawByteBuffer.get(currentTransactionOutputValueArray);
            BigInteger currentTransactionOutputValue = new BigInteger(1, EthereumUtil.reverseByteArray(currentTransactionOutputValueArray));
            byte[] currentTransactionTxOutScriptLengthVarInt = BitcoinUtil.convertVarIntByteBufferToByteArray(rawByteBuffer);
            long currentTransactionTxOutScriptSize = BitcoinUtil.getVarInt(currentTransactionTxOutScriptLengthVarInt);
            int currentTransactionTxOutScriptSizeInt = (int)currentTransactionTxOutScriptSize;
            byte[] currentTransactionOutScript = new byte[currentTransactionTxOutScriptSizeInt];
            rawByteBuffer.get(currentTransactionOutScript, 0, currentTransactionTxOutScriptSizeInt);
            currentTransactionOutput.add(new BitcoinTransactionOutput(currentTransactionOutputValue, currentTransactionTxOutScriptLengthVarInt, currentTransactionOutScript));
            ++i;
        }
        return currentTransactionOutput;
    }

    public ByteBuffer readRawBlock() throws BitcoinBlockReadException {
        try {
            ByteBuffer result;
            int readByte;
            byte[] blockSizeByte = new byte[]{};
            while (blockSizeByte.length == 0) {
                if (this.bin.available() < 1) {
                    return null;
                }
                blockSizeByte = this.skipBlocksNotInFilter();
            }
            long blockSize = BitcoinUtil.getSize(blockSizeByte) + 8L;
            if (blockSize == 0L) {
                throw new BitcoinBlockReadException("Error: Blocksize too small");
            }
            if (blockSize < 0L) {
                throw new BitcoinBlockReadException("Error: This block size cannot be handled currently (larger then largest number in positive signed int)");
            }
            if (blockSize > (long)this.maxSizeBitcoinBlock) {
                throw new BitcoinBlockReadException("Error: Block size is larger then defined in configuration - Please increase it if this is a valid block");
            }
            int blockSizeInt = (int)blockSize;
            byte[] fullBlock = new byte[blockSizeInt];
            int totalByteRead = 0;
            while ((readByte = this.bin.read(fullBlock, totalByteRead, blockSizeInt - totalByteRead)) > -1 && (long)(totalByteRead += readByte) < blockSize) {
            }
            if ((long)totalByteRead != blockSize) {
                throw new BitcoinBlockReadException("Error: Could not read full block");
            }
            if (!this.useDirectBuffer) {
                result = ByteBuffer.wrap(fullBlock);
            } else {
                this.preAllocatedDirectByteBuffer.clear();
                this.preAllocatedDirectByteBuffer.limit(fullBlock.length);
                result = this.preAllocatedDirectByteBuffer;
                result.put(fullBlock);
                result.flip();
            }
            result.order(ByteOrder.LITTLE_ENDIAN);
            return result;
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new BitcoinBlockReadException(e.toString());
        }
    }

    public byte[] getKeyFromRawBlock(ByteBuffer rawByteBuffer) {
        rawByteBuffer.mark();
        byte[] magicNo = new byte[4];
        byte[] hashMerkleRoot = new byte[32];
        byte[] hashPrevBlock = new byte[32];
        rawByteBuffer.get(magicNo, 0, 4);
        rawByteBuffer.getInt();
        rawByteBuffer.getInt();
        rawByteBuffer.get(hashPrevBlock, 0, 32);
        rawByteBuffer.get(hashMerkleRoot, 0, 32);
        byte[] result = new byte[hashMerkleRoot.length + hashPrevBlock.length];
        for (int i = 0; i < hashMerkleRoot.length; ++i) {
            result[i] = hashMerkleRoot[i];
        }
        for (int j = 0; j < hashPrevBlock.length; ++j) {
            result[j + hashMerkleRoot.length] = hashPrevBlock[j];
        }
        rawByteBuffer.reset();
        return result;
    }

    public void close() throws IOException {
        this.bin.close();
    }

    private void findMagic() throws BitcoinBlockReadException {
        for (int currentSeek = 0; currentSeek != this.maxSizeBitcoinBlock; ++currentSeek) {
            int firstByte = -1;
            try {
                this.bin.mark(4);
                firstByte = this.bin.read();
            }
            catch (IOException e) {
                LOG.error((Object)e);
                throw new BitcoinBlockReadException(e.toString());
            }
            if (firstByte == -1) {
                throw new BitcoinBlockReadException("Error: Did not find defined magic within current stream");
            }
            try {
                if (this.checkForMagicBytes(firstByte)) {
                    return;
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                throw new BitcoinBlockReadException(e.toString());
            }
            if (currentSeek == this.maxSizeBitcoinBlock) {
                throw new BitcoinBlockReadException("Error: Cannot seek to a block start, because no valid block found within the maximum size of a Bitcoin block. Check data or increase maximum size of Bitcoin block.");
            }
            try {
                this.bin.reset();
                if (this.bin.skip(1L) == 1L) continue;
                LOG.error((Object)"Error cannot skip 1 byte in InputStream");
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)e);
                throw new BitcoinBlockReadException(e.toString());
            }
        }
    }

    private void checkFullBlock() throws BitcoinBlockReadException {
        try {
            this.bin.mark(this.maxSizeBitcoinBlock);
            long skipMagic = this.bin.skip(4L);
            if (skipMagic != 4L) {
                throw new BitcoinBlockReadException("Error: Cannot seek to a block start, because no valid block found. Cannot skip forward magic");
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new BitcoinBlockReadException(e.toString());
        }
        byte[] blockSizeArray = new byte[4];
        try {
            int readByte;
            int maxByteRead = 4;
            int totalByteRead = 0;
            while ((readByte = this.bin.read(blockSizeArray, totalByteRead, maxByteRead - totalByteRead)) > -1 && (totalByteRead += readByte) < maxByteRead) {
            }
            if (totalByteRead != maxByteRead) {
                throw new BitcoinBlockReadException("Error: Cannot seek to a block start, because no valid block found. Cannot read size of block");
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new BitcoinBlockReadException(e.toString());
        }
        long blockSize = BitcoinUtil.getSize(blockSizeArray);
        if ((long)this.maxSizeBitcoinBlock < blockSize) {
            throw new BitcoinBlockReadException("Error: Cannot seek to a block start, because no valid block found. Max bitcoin block size is smaller than current block size.");
        }
        int blockSizeInt = (int)blockSize;
        byte[] blockRead = new byte[blockSizeInt];
        int totalByteRead = 0;
        try {
            int readByte;
            while ((readByte = this.bin.read(blockRead, totalByteRead, blockSizeInt - totalByteRead)) > -1 && (long)(totalByteRead += readByte) < blockSize) {
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new BitcoinBlockReadException(e.toString());
        }
        if ((long)totalByteRead != blockSize) {
            throw new BitcoinBlockReadException("Error: Cannot seek to a block start, because no valid block found. Cannot skip to end of block");
        }
        try {
            this.bin.reset();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new BitcoinBlockReadException(e.toString());
        }
    }

    private byte[] skipBlocksNotInFilter() throws IOException {
        int readByte;
        byte[] magicNo = new byte[4];
        byte[] blockSizeByte = new byte[4];
        this.bin.mark(8);
        int maxByteRead = 4;
        int totalByteRead = 0;
        while ((readByte = this.bin.read(magicNo, totalByteRead, maxByteRead - totalByteRead)) > -1 && (totalByteRead += readByte) < maxByteRead) {
        }
        if (totalByteRead != maxByteRead) {
            return new byte[0];
        }
        maxByteRead = 4;
        totalByteRead = 0;
        while ((readByte = this.bin.read(blockSizeByte, totalByteRead, maxByteRead - totalByteRead)) > -1 && (totalByteRead += readByte) < maxByteRead) {
        }
        if (totalByteRead != maxByteRead) {
            return new byte[0];
        }
        long blockSize = BitcoinUtil.getSize(blockSizeByte) + 8L;
        this.bin.reset();
        if (this.filterSpecificMagic) {
            for (int i = 0; i < this.specificMagicByteArray.length; ++i) {
                byte[] currentFilter = this.specificMagicByteArray[i];
                boolean doesMatchOneMagic = BitcoinUtil.compareMagics(currentFilter, magicNo);
                if (!doesMatchOneMagic) continue;
                return blockSizeByte;
            }
            if (this.bin.skip(blockSize) != blockSize) {
                LOG.error((Object)"Cannot skip block in InputStream");
            }
            return new byte[0];
        }
        return blockSizeByte;
    }

    private boolean checkForMagicBytes(int firstByte) throws IOException {
        byte[] fullMagic = null;
        for (int i = 0; i < this.specificMagicByteArray.length; ++i) {
            int currentMagicFirstbyte = this.specificMagicByteArray[i][0] & 0xFF;
            if (firstByte != currentMagicFirstbyte) continue;
            if (fullMagic == null) {
                int readByte;
                fullMagic = new byte[4];
                fullMagic[0] = this.specificMagicByteArray[i][0];
                int maxByteRead = 4;
                int totalByteRead = 1;
                while ((readByte = this.bin.read(fullMagic, totalByteRead, maxByteRead - totalByteRead)) > -1 && (totalByteRead += readByte) < maxByteRead) {
                }
                if (totalByteRead != maxByteRead) {
                    return false;
                }
            }
            if (!BitcoinUtil.compareMagics(fullMagic, this.specificMagicByteArray[i])) continue;
            this.bin.reset();
            return true;
        }
        return false;
    }
}

