/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.common;

import java.util.Arrays;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;

public class BitcoinScriptPatternParser {
    private BitcoinScriptPatternParser() {
    }

    public static String getPaymentDestination(byte[] scriptPubKey) {
        if (scriptPubKey == null) {
            return null;
        }
        if (scriptPubKey.length == 0) {
            return "anyone";
        }
        String payToHashSegwit = BitcoinScriptPatternParser.checkP2WPKHP2SH(scriptPubKey);
        if (payToHashSegwit != null) {
            return payToHashSegwit;
        }
        String payToP2WSHSegwit = BitcoinScriptPatternParser.checkP2WSH(scriptPubKey);
        if (payToP2WSHSegwit != null) {
            return payToP2WSHSegwit;
        }
        String payToPubKeySegwit = BitcoinScriptPatternParser.checkP2WPKH(scriptPubKey);
        if (payToPubKeySegwit != null) {
            return payToPubKeySegwit;
        }
        String payToHash = BitcoinScriptPatternParser.checkPayToHash(scriptPubKey);
        if (payToHash != null) {
            return payToHash;
        }
        String payToPubKey = BitcoinScriptPatternParser.checkPayToPubKey(scriptPubKey);
        if (payToPubKey != null) {
            return payToPubKey;
        }
        if (scriptPubKey.length > 0 && (scriptPubKey[0] & 0xFF) == 170 && (scriptPubKey[scriptPubKey.length - 1] & 0xFF) == 135) {
            byte[] puzzle = Arrays.copyOfRange(scriptPubKey, 1, scriptPubKey.length - 2);
            return "puzzle_" + BitcoinUtil.convertByteArrayToHexString(puzzle);
        }
        if (scriptPubKey.length > 0 && (scriptPubKey[0] & 0xFF) == 106) {
            return "unspendable";
        }
        return null;
    }

    private static String checkP2WPKH(byte[] scriptPubKey) {
        if (scriptPubKey.length == 22 && scriptPubKey[0] == 0 && scriptPubKey[1] == 20) {
            byte[] keyhash = Arrays.copyOfRange(scriptPubKey, 2, 22);
            return "P2WPKH_" + BitcoinUtil.convertByteArrayToHexString(keyhash);
        }
        return null;
    }

    private static String checkP2WPKHP2SH(byte[] scriptPubKey) {
        boolean validEnd;
        boolean validLength;
        boolean bl = validLength = scriptPubKey.length == 23;
        if (!validLength) {
            return null;
        }
        boolean validStart = (scriptPubKey[0] & 0xFF) == 169 && (scriptPubKey[1] & 0xFF) == 20;
        boolean bl2 = validEnd = (scriptPubKey[22] & 0xFF) == 135;
        if (validStart && validEnd) {
            byte[] keyhash = Arrays.copyOfRange(scriptPubKey, 2, 22);
            return "P2WPKHP2SH_" + BitcoinUtil.convertByteArrayToHexString(keyhash);
        }
        return null;
    }

    private static String checkP2WSH(byte[] scriptPubKey) {
        if (scriptPubKey.length == 34 && scriptPubKey[0] == 0 && scriptPubKey[1] == 32) {
            byte[] keyhash = Arrays.copyOfRange(scriptPubKey, 2, 34);
            return "P2WSH_" + BitcoinUtil.convertByteArrayToHexString(keyhash);
        }
        return null;
    }

    private static String checkPayToHash(byte[] scriptPubKey) {
        boolean validEnd;
        boolean validLength;
        boolean bl = validLength = scriptPubKey.length == 25;
        if (!validLength) {
            return null;
        }
        boolean validStart = (scriptPubKey[0] & 0xFF) == 118 && (scriptPubKey[1] & 0xFF) == 169 && (scriptPubKey[2] & 0xFF) == 20;
        boolean bl2 = validEnd = (scriptPubKey[23] & 0xFF) == 136 && (scriptPubKey[24] & 0xFF) == 172;
        if (validStart && validEnd) {
            byte[] bitcoinAddress = Arrays.copyOfRange(scriptPubKey, 3, 23);
            return "bitcoinaddress_" + BitcoinUtil.convertByteArrayToHexString(bitcoinAddress);
        }
        return null;
    }

    private static String checkPayToPubKey(byte[] scriptPubKey) {
        if (scriptPubKey.length > 0 && (scriptPubKey[scriptPubKey.length - 1] & 0xFF) == 172) {
            byte[] publicKey = Arrays.copyOfRange(scriptPubKey, 0, scriptPubKey.length - 1);
            return "bitcoinpubkey_" + BitcoinUtil.convertByteArrayToHexString(publicKey);
        }
        return null;
    }
}

