/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinScriptWitnessItem;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransactionInput;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransactionOutput;

public class BitcoinTransaction
implements Serializable,
Writable {
    private int version;
    private byte marker;
    private byte flag;
    private byte[] inCounter;
    private byte[] outCounter;
    private List<BitcoinTransactionInput> listOfInputs;
    private List<BitcoinTransactionOutput> listOfOutputs;
    private List<BitcoinScriptWitnessItem> listOfScriptWitnessItem;
    private int lockTime;

    public BitcoinTransaction() {
        this.version = 0;
        this.marker = 1;
        this.flag = 0;
        this.inCounter = new byte[0];
        this.outCounter = new byte[0];
        this.listOfInputs = new ArrayList<BitcoinTransactionInput>();
        this.listOfOutputs = new ArrayList<BitcoinTransactionOutput>();
        this.listOfScriptWitnessItem = new ArrayList<BitcoinScriptWitnessItem>();
        this.lockTime = 0;
    }

    public BitcoinTransaction(int version, byte[] inCounter, List<BitcoinTransactionInput> listOfInputs, byte[] outCounter, List<BitcoinTransactionOutput> listOfOutputs, int lockTime) {
        this.marker = 1;
        this.flag = 0;
        this.version = version;
        this.inCounter = inCounter;
        this.listOfInputs = listOfInputs;
        this.outCounter = outCounter;
        this.listOfOutputs = listOfOutputs;
        this.listOfScriptWitnessItem = new ArrayList<BitcoinScriptWitnessItem>();
        this.lockTime = lockTime;
    }

    public BitcoinTransaction(byte marker, byte flag, int version, byte[] inCounter, List<BitcoinTransactionInput> listOfInputs, byte[] outCounter, List<BitcoinTransactionOutput> listOfOutputs, List<BitcoinScriptWitnessItem> listOfScriptWitnessItem, int lockTime) {
        this.marker = marker;
        this.flag = flag;
        this.version = version;
        this.inCounter = inCounter;
        this.listOfInputs = listOfInputs;
        this.outCounter = outCounter;
        this.listOfOutputs = listOfOutputs;
        this.listOfScriptWitnessItem = listOfScriptWitnessItem;
        this.lockTime = lockTime;
    }

    public int getVersion() {
        return this.version;
    }

    public byte getMarker() {
        return this.marker;
    }

    public byte getFlag() {
        return this.flag;
    }

    public byte[] getInCounter() {
        return this.inCounter;
    }

    public List<BitcoinTransactionInput> getListOfInputs() {
        return this.listOfInputs;
    }

    public byte[] getOutCounter() {
        return this.outCounter;
    }

    public List<BitcoinTransactionOutput> getListOfOutputs() {
        return this.listOfOutputs;
    }

    public List<BitcoinScriptWitnessItem> getBitcoinScriptWitness() {
        return this.listOfScriptWitnessItem;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public void set(BitcoinTransaction newTransaction) {
        this.version = newTransaction.getVersion();
        this.marker = newTransaction.getMarker();
        this.flag = newTransaction.getFlag();
        this.inCounter = newTransaction.getInCounter();
        this.listOfInputs = newTransaction.getListOfInputs();
        this.outCounter = newTransaction.getOutCounter();
        this.listOfOutputs = newTransaction.getListOfOutputs();
        this.listOfScriptWitnessItem = newTransaction.getBitcoinScriptWitness();
        this.lockTime = newTransaction.getLockTime();
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("write unsupported");
    }

    public void readFields(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("readFields unsupported");
    }
}

