/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinScriptWitnessItem;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransaction;

public class BitcoinUtil {
    private static final Log LOG = LogFactory.getLog((String)BitcoinUtil.class.getName());

    private BitcoinUtil() {
    }

    public static long convertSignedIntToUnsigned(int signedInt) {
        return (long)signedInt & 0xFFFFFFFFL;
    }

    public static byte[] convertIntToByteArray(int intToConvert) {
        return ByteBuffer.allocate(4).putInt(intToConvert).array();
    }

    public static byte[] convertLongToByteArray(long longToConvert) {
        return ByteBuffer.allocate(8).putLong(longToConvert).array();
    }

    public static byte[] convertBigIntegerToByteArray(BigInteger bigIntegerToConvert, int exactArraySize) {
        if (bigIntegerToConvert == null || bigIntegerToConvert.signum() == -1) {
            return null;
        }
        byte[] tempResult = bigIntegerToConvert.toByteArray();
        byte[] result = new byte[exactArraySize];
        int removeSign = 0;
        if (tempResult.length > 1 && tempResult[0] == 0) {
            removeSign = 1;
        }
        byte[] reverseTempResult = BitcoinUtil.reverseByteArray(tempResult);
        for (int i = 0; i < result.length; ++i) {
            if (i >= reverseTempResult.length - removeSign) continue;
            result[i] = reverseTempResult[i];
        }
        return result;
    }

    public static byte[] convertVarIntByteBufferToByteArray(ByteBuffer byteBuffer) {
        byte originalVarIntSize = byteBuffer.get();
        byte varIntSize = BitcoinUtil.getVarIntSize(originalVarIntSize);
        byte[] varInt = new byte[varIntSize];
        varInt[0] = originalVarIntSize;
        byteBuffer.get(varInt, 1, varIntSize - 1);
        return varInt;
    }

    public static long convertVarIntByteBufferToLong(ByteBuffer byteBuffer) {
        byte[] varIntByteArray = BitcoinUtil.convertVarIntByteBufferToByteArray(byteBuffer);
        return BitcoinUtil.getVarInt(varIntByteArray);
    }

    public static BigInteger getVarIntBI(byte[] varInt) {
        BigInteger result = BigInteger.ZERO;
        if (varInt.length == 0) {
            return result;
        }
        int unsignedByte = varInt[0] & 0xFF;
        if (unsignedByte < 253) {
            return new BigInteger(new byte[]{(byte)unsignedByte});
        }
        int intSize = 0;
        if (unsignedByte == 253) {
            intSize = 3;
        } else if (unsignedByte == 254) {
            intSize = 5;
        } else if (unsignedByte == 255) {
            intSize = 9;
        }
        byte[] rawDataInt = BitcoinUtil.reverseByteArray(Arrays.copyOfRange(varInt, 1, intSize));
        return new BigInteger(rawDataInt);
    }

    public static long getVarInt(byte[] varInt) {
        long result = 0L;
        if (varInt.length == 0) {
            return result;
        }
        int unsignedByte = varInt[0] & 0xFF;
        if (unsignedByte < 253) {
            return unsignedByte;
        }
        int intSize = 0;
        if (unsignedByte == 253) {
            intSize = 3;
        } else if (unsignedByte == 254) {
            intSize = 5;
        } else if (unsignedByte == 255) {
            intSize = 9;
        }
        byte[] rawDataInt = BitcoinUtil.reverseByteArray(Arrays.copyOfRange(varInt, 1, intSize));
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawDataInt);
        if (intSize == 3) {
            result = byteBuffer.getShort();
        } else if (intSize == 5) {
            result = byteBuffer.getInt();
        } else if (intSize == 9) {
            result = byteBuffer.getLong();
        }
        return result;
    }

    public static byte getVarIntSize(byte firstByteVarInt) {
        int unsignedByte = firstByteVarInt & 0xFF;
        if (unsignedByte == 253) {
            return 3;
        }
        if (unsignedByte == 254) {
            return 5;
        }
        if (unsignedByte == 255) {
            return 9;
        }
        return 1;
    }

    public static long getSize(byte[] byteSize) {
        if (byteSize.length != 4) {
            return 0L;
        }
        ByteBuffer converterBuffer = ByteBuffer.wrap(byteSize);
        converterBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return BitcoinUtil.convertSignedIntToUnsigned(converterBuffer.getInt());
    }

    public static byte[] reverseByteArray(byte[] inputByteArray) {
        byte[] result = new byte[inputByteArray.length];
        for (int i = inputByteArray.length - 1; i >= 0; --i) {
            result[result.length - 1 - i] = inputByteArray[i];
        }
        return result;
    }

    public static byte[] convertHexStringToByteArray(String hexString) {
        return DatatypeConverter.parseHexBinary((String)hexString);
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        return DatatypeConverter.printHexBinary((byte[])byteArray);
    }

    public static Date convertIntToDate(int dateInt) {
        return new Date((long)dateInt * 1000L);
    }

    public static boolean compareMagics(byte[] magic1, byte[] magic2) {
        if (magic1.length != magic2.length) {
            return false;
        }
        for (int i = 0; i < magic1.length; ++i) {
            if (magic1[i] == magic2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getTransactionHash(BitcoinTransaction transaction) throws IOException {
        byte[] secondRoundHash;
        ByteArrayOutputStream transactionBAOS = new ByteArrayOutputStream();
        byte[] version = BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray(transaction.getVersion()));
        transactionBAOS.write(version);
        byte[] inCounter = transaction.getInCounter();
        transactionBAOS.write(inCounter);
        for (int i = 0; i < transaction.getListOfInputs().size(); ++i) {
            transactionBAOS.write(transaction.getListOfInputs().get(i).getPrevTransactionHash());
            transactionBAOS.write(BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray((int)transaction.getListOfInputs().get(i).getPreviousTxOutIndex())));
            transactionBAOS.write(transaction.getListOfInputs().get(i).getTxInScriptLength());
            transactionBAOS.write(transaction.getListOfInputs().get(i).getTxInScript());
            transactionBAOS.write(BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray((int)transaction.getListOfInputs().get(i).getSeqNo())));
        }
        byte[] outCounter = transaction.getOutCounter();
        transactionBAOS.write(outCounter);
        for (int j = 0; j < transaction.getListOfOutputs().size(); ++j) {
            transactionBAOS.write(BitcoinUtil.convertBigIntegerToByteArray(transaction.getListOfOutputs().get(j).getValue(), 8));
            transactionBAOS.write(transaction.getListOfOutputs().get(j).getTxOutScriptLength());
            transactionBAOS.write(transaction.getListOfOutputs().get(j).getTxOutScript());
        }
        byte[] lockTime = BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray(transaction.getLockTime()));
        transactionBAOS.write(lockTime);
        byte[] transactionByteArray = transactionBAOS.toByteArray();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] firstRoundHash = digest.digest(transactionByteArray);
            secondRoundHash = digest.digest(firstRoundHash);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error((Object)nsae);
            return new byte[0];
        }
        return secondRoundHash;
    }

    public static byte[] getTransactionHashSegwit(BitcoinTransaction transaction) throws IOException {
        byte[] secondRoundHash;
        ByteArrayOutputStream transactionBAOS = new ByteArrayOutputStream();
        byte[] version = BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray(transaction.getVersion()));
        transactionBAOS.write(version);
        boolean segwit = false;
        if (transaction.getMarker() == 0 && transaction.getFlag() != 0) {
            segwit = true;
            boolean emptyWitness = true;
            for (int k = 0; k < transaction.getBitcoinScriptWitness().size(); ++k) {
                BitcoinScriptWitnessItem currentItem = transaction.getBitcoinScriptWitness().get(k);
                if (currentItem.getStackItemCounter().length > 1) {
                    emptyWitness = false;
                    break;
                }
                if (currentItem.getStackItemCounter().length != 1 || currentItem.getStackItemCounter()[0] == 0) continue;
                emptyWitness = false;
                break;
            }
            if (emptyWitness) {
                return BitcoinUtil.getTransactionHashSegwit(transaction);
            }
            transactionBAOS.write(transaction.getMarker());
            transactionBAOS.write(transaction.getFlag());
        }
        byte[] inCounter = transaction.getInCounter();
        transactionBAOS.write(inCounter);
        for (int i = 0; i < transaction.getListOfInputs().size(); ++i) {
            transactionBAOS.write(transaction.getListOfInputs().get(i).getPrevTransactionHash());
            transactionBAOS.write(BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray((int)transaction.getListOfInputs().get(i).getPreviousTxOutIndex())));
            transactionBAOS.write(transaction.getListOfInputs().get(i).getTxInScriptLength());
            transactionBAOS.write(transaction.getListOfInputs().get(i).getTxInScript());
            transactionBAOS.write(BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray((int)transaction.getListOfInputs().get(i).getSeqNo())));
        }
        byte[] outCounter = transaction.getOutCounter();
        transactionBAOS.write(outCounter);
        for (int j = 0; j < transaction.getListOfOutputs().size(); ++j) {
            transactionBAOS.write(BitcoinUtil.convertBigIntegerToByteArray(transaction.getListOfOutputs().get(j).getValue(), 8));
            transactionBAOS.write(transaction.getListOfOutputs().get(j).getTxOutScriptLength());
            transactionBAOS.write(transaction.getListOfOutputs().get(j).getTxOutScript());
        }
        if (segwit) {
            for (int k = 0; k < transaction.getBitcoinScriptWitness().size(); ++k) {
                BitcoinScriptWitnessItem currentItem = transaction.getBitcoinScriptWitness().get(k);
                transactionBAOS.write(currentItem.getStackItemCounter());
                for (int l = 0; l < currentItem.getScriptWitnessList().size(); ++l) {
                    transactionBAOS.write(currentItem.getScriptWitnessList().get(l).getWitnessScriptLength());
                    transactionBAOS.write(currentItem.getScriptWitnessList().get(l).getWitnessScript());
                }
            }
        }
        byte[] lockTime = BitcoinUtil.reverseByteArray(BitcoinUtil.convertIntToByteArray(transaction.getLockTime()));
        transactionBAOS.write(lockTime);
        byte[] transactionByteArray = transactionBAOS.toByteArray();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] firstRoundHash = digest.digest(transactionByteArray);
            secondRoundHash = digest.digest(firstRoundHash);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error((Object)nsae);
            return new byte[0];
        }
        return secondRoundHash;
    }
}

