/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public abstract class AbstractBitcoinFileInputFormat<K, V>
extends FileInputFormat<K, V>
implements JobConfigurable {
    public static final String CONF_ISSPLITABLE = "hadoopcryptoledeger.bitcoinblockinputformat.issplitable";
    public static final boolean DEFAULT_ISSPLITABLE = false;
    private boolean isSplitable = false;
    private CompressionCodecFactory compressionCodecs = null;

    public abstract RecordReader<K, V> getRecordReader(InputSplit var1, JobConf var2, Reporter var3) throws IOException;

    public void configure(JobConf conf) {
        this.compressionCodecs = new CompressionCodecFactory((Configuration)conf);
        this.isSplitable = conf.getBoolean(CONF_ISSPLITABLE, false);
    }

    protected boolean isSplitable(FileSystem fs, Path file) {
        if (!this.isSplitable) {
            return false;
        }
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }
}

