/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapred;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapred.AbstractBitcoinRecordReader;

public class BitcoinRawBlockRecordReader
extends AbstractBitcoinRecordReader<BytesWritable, BytesWritable> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinRawBlockRecordReader.class.getName());

    public BitcoinRawBlockRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException, HadoopCryptoLedgerConfigurationException, BitcoinBlockReadException {
        super(split, job, reporter);
    }

    public BytesWritable createKey() {
        return new BytesWritable();
    }

    public BytesWritable createValue() {
        return new BytesWritable();
    }

    public boolean next(BytesWritable key, BytesWritable value) throws IOException {
        if (this.getFilePosition() <= this.getEnd()) {
            byte[] dataBlockArray;
            ByteBuffer dataBlock = null;
            try {
                dataBlock = this.getBbr().readRawBlock();
            }
            catch (BitcoinBlockReadException e) {
                LOG.error((Object)e);
            }
            if (dataBlock == null) {
                return false;
            }
            byte[] newKey = this.getBbr().getKeyFromRawBlock(dataBlock);
            key.set(newKey, 0, newKey.length);
            if (dataBlock.hasArray()) {
                dataBlockArray = dataBlock.array();
            } else {
                dataBlockArray = new byte[dataBlock.capacity()];
                dataBlock.get(dataBlockArray);
            }
            value.set(dataBlockArray, 0, dataBlockArray.length);
            return true;
        }
        return false;
    }
}

