/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransaction;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapred.AbstractBitcoinRecordReader;
import org.zuinnote.hadoop.bitcoin.format.mapred.BitcoinBlockRecordReader;

public class BitcoinTransactionRecordReader
extends AbstractBitcoinRecordReader<BytesWritable, BitcoinTransaction> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockRecordReader.class.getName());
    private int currentTransactionCounterInBlock = 0;
    private BitcoinBlock currentBitcoinBlock;

    public BitcoinTransactionRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException, HadoopCryptoLedgerConfigurationException, BitcoinBlockReadException {
        super(split, job, reporter);
    }

    public BytesWritable createKey() {
        return new BytesWritable();
    }

    public BitcoinTransaction createValue() {
        return new BitcoinTransaction();
    }

    public boolean next(BytesWritable key, BitcoinTransaction value) throws IOException {
        if (this.getFilePosition() <= this.getEnd()) {
            if (this.currentBitcoinBlock == null || this.currentBitcoinBlock.getTransactions().size() == this.currentTransactionCounterInBlock) {
                try {
                    this.currentBitcoinBlock = this.getBbr().readBlock();
                    this.currentTransactionCounterInBlock = 0;
                }
                catch (BitcoinBlockReadException e) {
                    LOG.error((Object)e);
                }
            }
            if (this.currentBitcoinBlock == null) {
                return false;
            }
            BitcoinTransaction currentTransaction = this.currentBitcoinBlock.getTransactions().get(this.currentTransactionCounterInBlock);
            byte[] newKey = BitcoinUtil.getTransactionHash(currentTransaction);
            key.set(newKey, 0, newKey.length);
            value.set(currentTransaction);
            ++this.currentTransactionCounterInBlock;
            return true;
        }
        return false;
    }
}

