/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapreduce;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public abstract class AbstractBitcoinFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    public static final String CONF_ISSPLITABLE = "hadoopcryptoledeger.bitcoinblockinputformat.issplitable";
    public static final boolean DEFAULT_ISSPLITABLE = false;

    public abstract RecordReader<K, V> createRecordReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    protected boolean isSplitable(JobContext context, Path file) {
        boolean isSplitable = context.getConfiguration().getBoolean(CONF_ISSPLITABLE, false);
        if (!isSplitable) {
            return false;
        }
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }
}

