/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapreduce.AbstractBitcoinFileInputFormat;
import org.zuinnote.hadoop.bitcoin.format.mapreduce.BitcoinBlockRecordReader;

public class BitcoinBlockFileInputFormat
extends AbstractBitcoinFileInputFormat<BytesWritable, BitcoinBlock> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockFileInputFormat.class.getName());

    @Override
    public RecordReader<BytesWritable, BitcoinBlock> createRecordReader(InputSplit split, TaskAttemptContext ctx) throws IOException {
        try {
            return new BitcoinBlockRecordReader(ctx.getConfiguration());
        }
        catch (HadoopCryptoLedgerConfigurationException e) {
            LOG.error((Object)e);
            return null;
        }
    }
}

