/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapreduce.AbstractBitcoinRecordReader;

public class BitcoinBlockRecordReader
extends AbstractBitcoinRecordReader<BytesWritable, BitcoinBlock> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockRecordReader.class.getName());
    private BytesWritable currentKey = new BytesWritable();
    private BitcoinBlock currentValue = new BitcoinBlock();

    public BitcoinBlockRecordReader(Configuration conf) throws HadoopCryptoLedgerConfigurationException {
        super(conf);
    }

    public BytesWritable getCurrentKey() {
        return this.currentKey;
    }

    public BitcoinBlock getCurrentValue() {
        return this.currentValue;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.getFilePosition() <= this.getEnd()) {
            BitcoinBlock dataBlock = null;
            try {
                dataBlock = this.getBbr().readBlock();
            }
            catch (BitcoinBlockReadException e) {
                LOG.error((Object)e);
            }
            if (dataBlock == null) {
                return false;
            }
            byte[] hashMerkleRoot = dataBlock.getHashMerkleRoot();
            byte[] hashPrevBlock = dataBlock.getHashPrevBlock();
            byte[] newKey = new byte[hashMerkleRoot.length + hashPrevBlock.length];
            for (int i = 0; i < hashMerkleRoot.length; ++i) {
                newKey[i] = hashMerkleRoot[i];
            }
            for (int j = 0; j < hashPrevBlock.length; ++j) {
                newKey[j + hashMerkleRoot.length] = hashPrevBlock[j];
            }
            this.currentKey.set(newKey, 0, newKey.length);
            this.currentValue.set(dataBlock);
            return true;
        }
        return false;
    }
}

