/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapreduce;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapreduce.AbstractBitcoinRecordReader;

public class BitcoinRawBlockRecordReader
extends AbstractBitcoinRecordReader<BytesWritable, BytesWritable> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinRawBlockRecordReader.class.getName());
    private BytesWritable currentKey = new BytesWritable();
    private BytesWritable currentValue = new BytesWritable();

    public BitcoinRawBlockRecordReader(Configuration conf) throws HadoopCryptoLedgerConfigurationException {
        super(conf);
    }

    public BytesWritable getCurrentKey() {
        return this.currentKey;
    }

    public BytesWritable getCurrentValue() {
        return this.currentValue;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.getFilePosition() <= this.getEnd()) {
            byte[] dataBlockArray;
            ByteBuffer dataBlock = null;
            try {
                dataBlock = this.getBbr().readRawBlock();
            }
            catch (BitcoinBlockReadException e) {
                LOG.error((Object)e);
            }
            if (dataBlock == null) {
                return false;
            }
            byte[] newKey = this.getBbr().getKeyFromRawBlock(dataBlock);
            this.currentKey.set(newKey, 0, newKey.length);
            if (dataBlock.hasArray()) {
                dataBlockArray = dataBlock.array();
            } else {
                dataBlockArray = new byte[dataBlock.capacity()];
                dataBlock.get(dataBlockArray);
            }
            this.currentValue.set(dataBlockArray, 0, dataBlockArray.length);
            return true;
        }
        return false;
    }
}

