/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.bitcoin.format.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransaction;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;
import org.zuinnote.hadoop.bitcoin.format.mapreduce.AbstractBitcoinRecordReader;
import org.zuinnote.hadoop.bitcoin.format.mapreduce.BitcoinBlockRecordReader;

public class BitcoinTransactionRecordReader
extends AbstractBitcoinRecordReader<BytesWritable, BitcoinTransaction> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockRecordReader.class.getName());
    private int currentTransactionCounterInBlock = 0;
    private BitcoinBlock currentBitcoinBlock;
    private BytesWritable currentKey = new BytesWritable();
    private BitcoinTransaction currentValue = new BitcoinTransaction();

    public BitcoinTransactionRecordReader(Configuration conf) throws HadoopCryptoLedgerConfigurationException {
        super(conf);
    }

    public BytesWritable getCurrentKey() {
        return this.currentKey;
    }

    public BitcoinTransaction getCurrentValue() {
        return this.currentValue;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.getFilePosition() <= this.getEnd()) {
            if (this.currentBitcoinBlock == null || this.currentBitcoinBlock.getTransactions().size() == this.currentTransactionCounterInBlock) {
                try {
                    this.currentBitcoinBlock = this.getBbr().readBlock();
                    this.currentTransactionCounterInBlock = 0;
                }
                catch (BitcoinBlockReadException e) {
                    LOG.error((Object)e);
                }
            }
            if (this.currentBitcoinBlock == null) {
                return false;
            }
            BitcoinTransaction currentTransaction = this.currentBitcoinBlock.getTransactions().get(this.currentTransactionCounterInBlock);
            byte[] newKey = BitcoinUtil.getTransactionHash(currentTransaction);
            this.currentKey.set(newKey, 0, newKey.length);
            this.currentValue.set(currentTransaction);
            ++this.currentTransactionCounterInBlock;
            return true;
        }
        return false;
    }
}

