/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.ethereum.format.common.EthereumBlockReader;

public abstract class AbstractEthereumRecordReader<K, V>
implements RecordReader<K, V> {
    public static final String CONF_BUFFERSIZE = "io.file.buffer.size";
    public static final String CONF_MAXBLOCKSIZE = "hadoopcryptoledger.ethereumblockinputformat.maxblocksize";
    public static final String CONF_USEDIRECTBUFFER = "hadoopcryptoledeger.ethereumblockinputformat.usedirectbuffer";
    public static final int DEFAULT_BUFFERSIZE = 65536;
    public static final int DEFAULT_MAXSIZE_ETHEREUMBLOCK = 0x100000;
    public static final boolean DEFAULT_USEDIRECTBUFFER = false;
    private static final Log LOG = LogFactory.getLog((String)AbstractEthereumRecordReader.class.getName());
    private int bufferSize = 0;
    private int maxSizeEthereumBlock = 0;
    private boolean useDirectBuffer = false;
    private CompressionCodec codec;
    private Decompressor decompressor;
    private Reporter reporter;
    private Configuration conf;
    private long start;
    private long end;
    private final Seekable filePosition;
    private FSDataInputStream fileIn;
    private EthereumBlockReader ebr;

    public AbstractEthereumRecordReader(FileSplit split, JobConf job, Reporter reporter) throws IOException {
        LOG.debug((Object)"Reading configuration");
        this.reporter = reporter;
        this.conf = job;
        this.maxSizeEthereumBlock = this.conf.getInt(CONF_MAXBLOCKSIZE, 0x100000);
        this.bufferSize = this.conf.getInt(CONF_BUFFERSIZE, 65536);
        this.useDirectBuffer = this.conf.getBoolean(CONF_USEDIRECTBUFFER, false);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        this.codec = new CompressionCodecFactory((Configuration)job).getCodec(file);
        FileSystem fs = file.getFileSystem((Configuration)job);
        this.fileIn = fs.open(file);
        if (this.isCompressedInput()) {
            LOG.debug((Object)"Decompressing file");
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)this.codec);
            if (this.codec instanceof SplittableCompressionCodec) {
                LOG.debug((Object)"SplittableCompressionCodec");
                SplitCompressionInputStream cIn = ((SplittableCompressionCodec)this.codec).createInputStream((InputStream)this.fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.CONTINUOUS);
                this.ebr = new EthereumBlockReader((InputStream)cIn, this.maxSizeEthereumBlock, this.bufferSize, this.useDirectBuffer);
                this.start = cIn.getAdjustedStart();
                this.end = cIn.getAdjustedEnd();
                this.filePosition = cIn;
            } else {
                LOG.debug((Object)"Not-splitable compression codec");
                this.ebr = new EthereumBlockReader((InputStream)this.codec.createInputStream((InputStream)this.fileIn, this.decompressor), this.maxSizeEthereumBlock, this.bufferSize, this.useDirectBuffer);
                this.filePosition = this.fileIn;
            }
        } else {
            LOG.debug((Object)"Processing file without compression");
            this.fileIn.seek(this.start);
            this.ebr = new EthereumBlockReader((InputStream)this.fileIn, this.maxSizeEthereumBlock, this.bufferSize, this.useDirectBuffer);
            this.filePosition = this.fileIn;
        }
        this.reporter.setStatus("Ready to read");
    }

    public long getFilePosition() throws IOException {
        return this.filePosition.getPos();
    }

    public long getEnd() {
        return this.end;
    }

    public EthereumBlockReader getEbr() {
        return this.ebr;
    }

    public synchronized float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    private boolean isCompressedInput() {
        return this.codec != null;
    }

    public synchronized long getPos() throws IOException {
        return this.filePosition.getPos();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.ebr != null) {
                this.ebr.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }
}

