/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.ethereum.format.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.zuinnote.hadoop.ethereum.format.common.EthereumBlock;
import org.zuinnote.hadoop.ethereum.format.exception.EthereumBlockReadException;
import org.zuinnote.hadoop.ethereum.format.mapreduce.AbstractEthereumRecordReader;

public class EthereumBlockRecordReader
extends AbstractEthereumRecordReader<BytesWritable, EthereumBlock> {
    private static final Log LOG = LogFactory.getLog((String)EthereumBlockRecordReader.class.getName());
    private BytesWritable currentKey = new BytesWritable();
    private EthereumBlock currentValue = new EthereumBlock();

    public EthereumBlockRecordReader(Configuration conf) {
        super(conf);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.getFilePosition() <= this.getEnd()) {
            EthereumBlock dataBlock = null;
            try {
                dataBlock = this.getEbr().readBlock();
            }
            catch (EthereumBlockReadException e) {
                LOG.error((Object)e);
                throw new InterruptedException(e.toString());
            }
            if (dataBlock == null) {
                return false;
            }
            byte[] newKey = dataBlock.getEthereumBlockHeader().getParentHash();
            this.currentKey.set(newKey, 0, newKey.length);
            this.currentValue.set(dataBlock);
            return true;
        }
        return false;
    }

    public BytesWritable getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public EthereumBlock getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }
}

