/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.namecoin.format.common;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;

public class NamecoinUtil {
    private static final Log LOG = LogFactory.getLog((String)NamecoinUtil.class.getName());
    public static final byte OP_NAME_NEW = 81;
    public static final byte OP_NAME_FIRSTUPDATE = 82;
    public static final byte OP_NAME_UDPATE = 83;
    public static final String STR_OP_UNKNOWN = "unknown";
    public static final String STR_OP_NAME_NEW = "OP_NAME_NEW";
    public static final String STR_OP_NAME_FIRSTUPDATE = "OP_NAME_FIRSTUPDATE";
    public static final String STR_OP_NAME_UDPATE = "OP_NAME_UPDATE";

    public static String[] extractNamecoinField(byte[] scriptPubKey) {
        String value;
        String name;
        if (scriptPubKey == null || scriptPubKey.length < 2) {
            return null;
        }
        if (scriptPubKey[0] != 83 && scriptPubKey[0] != 82) {
            return null;
        }
        String[] result = new String[2];
        ByteBuffer scriptByteBuffer = ByteBuffer.wrap(scriptPubKey);
        scriptByteBuffer.get();
        long nameSize = BitcoinUtil.convertVarIntByteBufferToLong(scriptByteBuffer);
        byte[] nameByteArray = new byte[(int)nameSize];
        scriptByteBuffer.get(nameByteArray);
        result[0] = name = new String(nameByteArray, Charset.forName("UTF-8"));
        if (scriptPubKey[0] == 82) {
            long intermediateInformationSize = BitcoinUtil.convertVarIntByteBufferToLong(scriptByteBuffer);
            byte[] intermediateInformation = new byte[(int)intermediateInformationSize];
            scriptByteBuffer.get(intermediateInformation);
        }
        long valueSize = BitcoinUtil.convertVarIntByteBufferToLong(scriptByteBuffer);
        byte[] valueByteArray = new byte[(int)valueSize];
        scriptByteBuffer.get(valueByteArray);
        result[1] = value = new String(valueByteArray, Charset.forName("UTF-8"));
        return result;
    }

    public static String getNameOperation(byte[] scriptPubKey) {
        if (scriptPubKey == null) {
            return STR_OP_UNKNOWN;
        }
        if (scriptPubKey.length > 1) {
            byte nameOp = scriptPubKey[0];
            switch (nameOp) {
                case 81: {
                    return STR_OP_NAME_NEW;
                }
                case 82: {
                    return STR_OP_NAME_FIRSTUPDATE;
                }
                case 83: {
                    return STR_OP_NAME_UDPATE;
                }
            }
            return STR_OP_UNKNOWN;
        }
        return STR_OP_UNKNOWN;
    }
}

