/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapreduce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.mapreduce.AbstractSpreadSheetDocumentRecordReader;

public class ExcelRecordReader
extends AbstractSpreadSheetDocumentRecordReader<Text, ArrayWritable> {
    private static final Log LOG = LogFactory.getLog((String)ExcelRecordReader.class.getName());
    private FileSplit split;
    private Text currentKey = new Text("");
    private ArrayWritable currentValue = new ArrayWritable(SpreadSheetCellDAO.class);

    public ExcelRecordReader(Configuration conf, FileSplit split) throws IOException, FormatNotUnderstoodException, GeneralSecurityException {
        super(conf);
        LOG.debug((Object)"Initalizing ExcelRecordReader");
        this.split = split;
    }

    public Text getCurrentKey() {
        return this.currentKey;
    }

    public ArrayWritable getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        if (!this.getOfficeReader().getFiltered()) {
            return false;
        }
        Object[] objectArray = this.getOfficeReader().getNext();
        if (objectArray == null) {
            return false;
        }
        Writable[] cellRows = (SpreadSheetCellDAO[])objectArray;
        this.currentKey.set("[" + this.split.getPath().getName() + "]" + this.getOfficeReader().getCurrentSheetName() + "!A" + this.getOfficeReader().getCurrentRow());
        this.currentValue.set(cellRows);
        return true;
    }
}

