/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapred;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;
import org.zuinnote.hadoop.office.format.mapred.AbstractSpreadSheetDocumentFileInputFormat;
import org.zuinnote.hadoop.office.format.mapred.ExcelRecordReader;

public class ExcelFileInputFormat
extends AbstractSpreadSheetDocumentFileInputFormat {
    private static final Log LOGIF = LogFactory.getLog((String)ExcelFileInputFormat.class.getName());

    @Override
    public RecordReader<Text, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            job.set("hadoopoffice.read.mimeType", "ms-excel");
            return new ExcelRecordReader((FileSplit)split, job, reporter);
        }
        catch (FormatNotUnderstoodException e) {
            LOGIF.error((Object)e);
        }
        catch (GeneralSecurityException gse) {
            LOGIF.error((Object)gse);
        }
        return null;
    }

    @Override
    public void configure(JobConf conf) {
    }

    @Override
    protected boolean isSplitable(FileSystem fs, Path file) {
        return false;
    }
}

