/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.mapred;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.zuinnote.hadoop.office.format.common.HadoopUtil;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.writer.InvalidWriterConfigurationException;
import org.zuinnote.hadoop.office.format.common.writer.OfficeWriterException;
import org.zuinnote.hadoop.office.format.mapred.AbstractSpreadSheetDocumentFileOutputFormat;
import org.zuinnote.hadoop.office.format.mapred.ExcelRecordWriter;

public class ExcelFileOutputFormat
extends AbstractSpreadSheetDocumentFileOutputFormat<SpreadSheetCellDAO>
implements Serializable {
    private static final long serialVersionUID = -7935658549427761712L;
    private static final Log LOG = LogFactory.getLog((String)ExcelFileOutputFormat.class.getName());
    public static final Class defaultCompressorClass = GzipCodec.class;
    public static final String DEFAULT_MIMETYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String SUFFIX_OOXML = ".xlsx";
    public static final String SUFFIX_OLDEXCEL = ".xls";

    @Override
    public RecordWriter<NullWritable, SpreadSheetCellDAO> getRecordWriter(FileSystem ignored, JobConf conf, String name, Progressable progress) throws IOException {
        String defaultConf = conf.get("hadoopoffice.write.mimeType", DEFAULT_MIMETYPE);
        conf.set("hadoopoffice.write.mimeType", defaultConf);
        Path file = ExcelFileOutputFormat.getTaskOutputPath((JobConf)conf, (String)name);
        file = file.suffix(ExcelFileOutputFormat.getSuffix(conf.get("hadoopoffice.write.mimeType")));
        try {
            return new ExcelRecordWriter<NullWritable, SpreadSheetCellDAO>(HadoopUtil.getDataOutputStream((Configuration)conf, file, progress, ExcelFileOutputFormat.getCompressOutput((JobConf)conf), ExcelFileOutputFormat.getOutputCompressorClass((JobConf)conf, (Class)defaultCompressorClass)), file.getName(), (Configuration)conf);
        }
        catch (InvalidWriterConfigurationException | OfficeWriterException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static String getSuffix(String mimeType) {
        if (mimeType.contains("openxmlformats-officedocument.spreadsheetml")) {
            return SUFFIX_OOXML;
        }
        if (mimeType.contains("ms-excel")) {
            return SUFFIX_OLDEXCEL;
        }
        return ".unknown";
    }
}

