/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.poi.sl.draw.BitmapImageRenderer;
import org.apache.poi.sl.draw.DrawSimpleShape;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.PictureShape;
import org.apache.poi.sl.usermodel.RectAlign;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class DrawPictureShape
extends DrawSimpleShape {
    private static final POILogger LOG = POILogFactory.getLogger(DrawPictureShape.class);
    private static final String WMF_IMAGE_RENDERER = "org.apache.poi.hwmf.draw.HwmfSLImageRenderer";

    public DrawPictureShape(PictureShape<?, ?> shape) {
        super((SimpleShape<?, ?>)shape);
    }

    @Override
    public void drawContent(Graphics2D graphics) {
        PictureData data = this.getShape().getPictureData();
        if (data == null) {
            return;
        }
        Rectangle2D anchor = DrawPictureShape.getAnchor(graphics, this.getShape());
        Insets insets = this.getShape().getClipping();
        try {
            ImageRenderer renderer = DrawPictureShape.getImageRenderer(graphics, data.getContentType());
            renderer.loadImage(data.getData(), data.getContentType());
            renderer.drawImage(graphics, anchor, insets);
        }
        catch (IOException e) {
            LOG.log(7, "image can't be loaded/rendered.", e);
        }
    }

    public static ImageRenderer getImageRenderer(Graphics2D graphics, String contentType) {
        ImageRenderer renderer = (ImageRenderer)graphics.getRenderingHint(Drawable.IMAGE_RENDERER);
        if (renderer != null) {
            return renderer;
        }
        if (PictureData.PictureType.WMF.contentType.equals(contentType)) {
            try {
                Class<?> irc = DrawPictureShape.class.getClassLoader().loadClass(WMF_IMAGE_RENDERER);
                return (ImageRenderer)irc.newInstance();
            }
            catch (Exception e) {
                LOG.log(7, "WMF image renderer is not on the classpath - include poi-scratchpad jar!", e);
            }
        }
        return new BitmapImageRenderer();
    }

    @Override
    protected PictureShape<?, ?> getShape() {
        return (PictureShape)this.shape;
    }

    public void resize() {
        SimpleShape ps = this.getShape();
        Dimension dim = ps.getPictureData().getImageDimension();
        Rectangle2D origRect = ps.getAnchor();
        double x = origRect.getX();
        double y = origRect.getY();
        double w = dim.getWidth();
        double h = dim.getHeight();
        ps.setAnchor(new Rectangle2D.Double(x, y, w, h));
    }

    public void resize(Rectangle2D target) {
        this.resize(target, RectAlign.CENTER);
    }

    public void resize(Rectangle2D target, RectAlign align) {
        SimpleShape ps = this.getShape();
        Dimension dim = ps.getPictureData().getImageDimension();
        if (dim.width <= 0 || dim.height <= 0) {
            ps.setAnchor(target);
            return;
        }
        double w = target.getWidth();
        double h = target.getHeight();
        double sx = w / (double)dim.width;
        double sy = h / (double)dim.height;
        double dx = 0.0;
        double dy = 0.0;
        if (sx > sy) {
            w = sy * (double)dim.width;
            dx = target.getWidth() - w;
        } else if (sy > sx) {
            h = sx * (double)dim.height;
            dy = target.getHeight() - h;
        } else {
            ps.setAnchor(target);
            return;
        }
        double x = target.getX();
        double y = target.getY();
        switch (align) {
            case TOP: {
                x += dx / 2.0;
                break;
            }
            case TOP_RIGHT: {
                x += dx;
                break;
            }
            case RIGHT: {
                x += dx;
                y += dy / 2.0;
                break;
            }
            case BOTTOM_RIGHT: {
                x += dx;
                y += dy;
                break;
            }
            case BOTTOM: {
                x += dx / 2.0;
                y += dy;
                break;
            }
            case BOTTOM_LEFT: {
                y += dy;
                break;
            }
            case LEFT: {
                y += dy / 2.0;
                break;
            }
            case TOP_LEFT: {
                break;
            }
            default: {
                x += dx / 2.0;
                y += dy / 2.0;
            }
        }
        ps.setAnchor(new Rectangle2D.Double(x, y, w, h));
    }
}

