/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.parser.msexcel.internal;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.StaxHelper;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.parser.FormatNotUnderstoodException;

public class XSSFPullParser {
    public static final String CELLTYPE_STRING = "s";
    public static final String CELLTYPE_NUMBER = "n";
    public static final String CELL_NOT_PROCESSABLE = "not processable";
    private static final Log LOG = LogFactory.getLog((String)XSSFPullParser.class.getName());
    private boolean nextBeingCalled;
    private boolean finalized;
    private int nextRow;
    private int currentRow;
    private XMLEventReader xer;
    private SharedStringsTable sst;
    private StylesTable styles;
    private String sheetName;
    private DataFormatter dataFormatter;
    boolean isDate1904;

    public XSSFPullParser(String sheetName, InputStream sheetInputStream, SharedStringsTable sst, StylesTable styles, DataFormatter dataFormatter, boolean isDate1904) throws XMLStreamException {
        this.sheetName = sheetName;
        this.xer = StaxHelper.newXMLInputFactory().createXMLEventReader(sheetInputStream);
        this.nextBeingCalled = false;
        this.finalized = false;
        this.nextRow = 1;
        this.currentRow = 1;
        this.sst = sst;
        this.styles = styles;
        this.dataFormatter = dataFormatter;
        this.isDate1904 = isDate1904;
    }

    public boolean hasNext() throws XMLStreamException {
        this.nextBeingCalled = true;
        if (this.finalized) {
            return false;
        }
        if (this.currentRow > 1 && this.currentRow <= this.nextRow) {
            return true;
        }
        while (this.xer.hasNext()) {
            XMLEvent xe = this.xer.nextEvent();
            if (!xe.isStartElement() || !xe.asStartElement().getName().getLocalPart().equalsIgnoreCase("row")) continue;
            Attribute at = xe.asStartElement().getAttributeByName(new QName("r"));
            String atValue = at.getValue();
            this.nextRow = Integer.valueOf(atValue);
            return true;
        }
        this.finalized = true;
        return false;
    }

    public Object[] getNext() throws XMLStreamException, FormatNotUnderstoodException {
        Object[] result = null;
        if (!this.nextBeingCalled && !this.hasNext()) {
            return null;
        }
        if (this.finalized) {
            return null;
        }
        ArrayList<SpreadSheetCellDAO> cells = new ArrayList<SpreadSheetCellDAO>();
        if (this.currentRow == this.nextRow) {
            int currentCellCount = 0;
            while (this.xer.hasNext()) {
                XMLEvent xe = this.xer.nextEvent();
                if (xe.isEndElement()) {
                    if (!xe.asEndElement().getName().getLocalPart().equalsIgnoreCase("row")) continue;
                    break;
                }
                if (!xe.isStartElement() || !xe.asStartElement().getName().getLocalPart().equalsIgnoreCase("c")) continue;
                Attribute cellAddressAT = xe.asStartElement().getAttributeByName(new QName("r"));
                CellAddress currentCellAddress = new CellAddress(cellAddressAT.getValue());
                for (int i = currentCellCount; i < currentCellAddress.getColumn(); ++i) {
                    cells.add(null);
                    ++currentCellCount;
                }
                ++currentCellCount;
                Attribute cellTypeTAT = xe.asStartElement().getAttributeByName(new QName("t"));
                Attribute cellTypeSAT = xe.asStartElement().getAttributeByName(new QName(CELLTYPE_STRING));
                String cellFormattedValue = "";
                String cellFormula = "";
                String cellAddress = cellAddressAT.getValue();
                String cellComment = "";
                String cellSheetName = this.sheetName;
                while (!(xe.isEndElement() && xe.isEndElement() && xe.asEndElement().getName().getLocalPart().equalsIgnoreCase("c"))) {
                    XMLEvent xeSubCharacters;
                    xe = this.xer.nextEvent();
                    if (xe.isStartElement() && xe.asStartElement().getName().getLocalPart().equalsIgnoreCase("v")) {
                        xeSubCharacters = this.xer.nextEvent();
                        if (!xeSubCharacters.isCharacters()) {
                            LOG.error((Object)"Error parsing excel file. Value attribute (v) of cell does not contains characters");
                            continue;
                        }
                        cellFormattedValue = xeSubCharacters.asCharacters().getData();
                        if (cellTypeTAT != null) {
                            if (CELLTYPE_STRING.equals(cellTypeTAT.getValue())) {
                                int strIdx = Integer.valueOf(cellFormattedValue);
                                if (this.sst != null && this.sst.getCount() > strIdx) {
                                    cellFormattedValue = this.sst.getItemAt(strIdx).getString();
                                    continue;
                                }
                                cellFormattedValue = "";
                                continue;
                            }
                            if (!CELLTYPE_NUMBER.equals(cellTypeTAT.getValue())) continue;
                            int strStyleIdx = Integer.valueOf(cellTypeSAT.getValue());
                            XSSFCellStyle cellStyle = this.styles.getStyleAt(strStyleIdx);
                            cellFormattedValue = this.dataFormatter.formatRawCellContents(Double.valueOf(cellFormattedValue), cellStyle.getDataFormat(), cellStyle.getDataFormatString(), this.isDate1904);
                            continue;
                        }
                        LOG.warn((Object)"Cannot read celltype. Interpreting value as String");
                        continue;
                    }
                    if (xe.isStartElement() && xe.asStartElement().getName().getLocalPart().equalsIgnoreCase("f")) {
                        xeSubCharacters = this.xer.nextEvent();
                        if (!xeSubCharacters.isCharacters()) {
                            LOG.error((Object)"Error parsing excel file. Formula attribute (f) of cell does not contains characters");
                            continue;
                        }
                        cellFormula = xeSubCharacters.asCharacters().getData();
                        continue;
                    }
                    if (!xe.isStartElement() || !xe.asStartElement().getName().getLocalPart().equalsIgnoreCase("is")) continue;
                    cellFormattedValue = this.parseCellInlineStringText(this.xer);
                }
                cells.add(new SpreadSheetCellDAO(cellFormattedValue, cellComment, cellFormula, cellAddress, cellSheetName));
            }
        }
        result = new SpreadSheetCellDAO[cells.size()];
        result = cells.toArray(result);
        this.nextBeingCalled = false;
        ++this.currentRow;
        return result;
    }

    private String parseCellInlineStringText(XMLEventReader xer) throws XMLStreamException, FormatNotUnderstoodException {
        XMLEvent xe;
        String result = "";
        block11: while ((xe = xer.nextTag()).isStartElement()) {
            String elementName;
            switch (elementName = xe.asStartElement().getName().getLocalPart().toUpperCase()) {
                case "T": {
                    result = xer.getElementText();
                    continue block11;
                }
                case "R": {
                    result = this.parseCellInlineStringRichText(xer);
                    continue block11;
                }
                case "RPH": 
                case "PHONETICPR": {
                    this.skipXMLElementHierarchy(xer);
                    continue block11;
                }
            }
            LOG.error((Object)("Unknown inline string tag: " + elementName));
            throw new FormatNotUnderstoodException("Unknown inline string tag: " + elementName);
        }
        return result;
    }

    private String parseCellInlineStringRichText(XMLEventReader xer) throws XMLStreamException, FormatNotUnderstoodException {
        XMLEvent xe;
        String result = "";
        block7: while ((xe = xer.nextTag()).isStartElement()) {
            String elementName;
            switch (elementName = xe.asStartElement().getName().getLocalPart().toUpperCase()) {
                case "T": {
                    result = xer.getElementText();
                    continue block7;
                }
            }
            LOG.error((Object)("Unknown rich text inline string tag: " + elementName));
            throw new FormatNotUnderstoodException("Unknown rich text inline string tag: " + elementName);
        }
        return result;
    }

    private void skipXMLElementHierarchy(XMLEventReader xer) throws XMLStreamException {
        while (xer.nextTag().isStartElement()) {
            this.skipXMLElementHierarchy(xer);
        }
    }
}

