/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.util.CellAddress;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericBigDecimalDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericBooleanDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericByteDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericDateDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericDoubleDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericFloatDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericIntegerDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericLongDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericNumericDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericShortDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericStringDataType;
import org.zuinnote.hadoop.office.format.common.converter.datatypes.GenericTimestampDataType;
import org.zuinnote.hadoop.office.format.common.dao.SpreadSheetCellDAO;
import org.zuinnote.hadoop.office.format.common.util.msexcel.MSExcelUtil;

public class ExcelConverterSimpleSpreadSheetCellDAO
implements Serializable {
    private static final long serialVersionUID = 3281344931609307423L;
    private static final Log LOG = LogFactory.getLog((String)ExcelConverterSimpleSpreadSheetCellDAO.class.getName());
    private List<GenericDataType> schemaRow = new ArrayList<GenericDataType>();
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dateTimeFormat;
    private DecimalFormat decimalFormat;

    public ExcelConverterSimpleSpreadSheetCellDAO(SimpleDateFormat dateFormat, DecimalFormat decimalFormat) {
        this(dateFormat, decimalFormat, null);
    }

    public ExcelConverterSimpleSpreadSheetCellDAO(SimpleDateFormat dateFormat, DecimalFormat decimalFormat, SimpleDateFormat dateTimeFormat) {
        this.dateFormat = (SimpleDateFormat)dateFormat.clone();
        this.decimalFormat = (DecimalFormat)decimalFormat.clone();
        this.decimalFormat.setParseBigDecimal(true);
        if (dateTimeFormat != null) {
            this.dateTimeFormat = (SimpleDateFormat)dateTimeFormat.clone();
        }
    }

    public void updateSpreadSheetCellRowToInferSchemaInformation(SpreadSheetCellDAO[] dataRow) {
        for (SpreadSheetCellDAO currentSpreadSheetCellDAO : dataRow) {
            Date theDate;
            boolean dataTypeFound = false;
            if (currentSpreadSheetCellDAO == null) continue;
            int j = new CellAddress(currentSpreadSheetCellDAO.getAddress()).getColumn();
            if (j >= this.schemaRow.size()) {
                for (int x = this.schemaRow.size(); x <= j; ++x) {
                    this.schemaRow.add(null);
                }
            }
            if (currentSpreadSheetCellDAO.getFormattedValue() == null || "".equals(currentSpreadSheetCellDAO.getFormattedValue())) continue;
            String currentCellValue = currentSpreadSheetCellDAO.getFormattedValue();
            if ("TRUE".equals(currentCellValue) || "FALSE".equals(currentCellValue)) {
                dataTypeFound = true;
                if (this.schemaRow.get(j) != null) {
                    if (!(this.schemaRow.get(j) instanceof GenericBooleanDataType)) {
                        this.schemaRow.set(j, new GenericStringDataType());
                    }
                } else {
                    this.schemaRow.set(j, new GenericBooleanDataType());
                }
            }
            if (!dataTypeFound && this.dateTimeFormat != null && (theDate = this.dateTimeFormat.parse(currentCellValue, new ParsePosition(0))) != null) {
                dataTypeFound = true;
                if (this.schemaRow.get(j) != null) {
                    if (!(this.schemaRow.get(j) instanceof GenericTimestampDataType)) {
                        this.schemaRow.set(j, new GenericStringDataType());
                    }
                } else {
                    this.schemaRow.set(j, new GenericTimestampDataType());
                }
            }
            if (!dataTypeFound) {
                try {
                    Timestamp ts = Timestamp.valueOf(currentCellValue);
                    dataTypeFound = true;
                    this.schemaRow.set(j, new GenericTimestampDataType());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)"Could not identify timestamp using TimeStamp.valueOf. Trying last resort Date parsing....");
                }
            }
            if (!dataTypeFound && (theDate = this.dateFormat.parse(currentCellValue, new ParsePosition(0))) != null) {
                dataTypeFound = true;
                if (this.schemaRow.get(j) != null) {
                    if (!(this.schemaRow.get(j) instanceof GenericDateDataType)) {
                        this.schemaRow.set(j, new GenericStringDataType());
                    }
                } else {
                    this.schemaRow.set(j, new GenericDateDataType());
                }
            }
            BigDecimal bd = (BigDecimal)this.decimalFormat.parse(currentCellValue, new ParsePosition(0));
            if (!dataTypeFound && bd != null) {
                boolean isLong;
                boolean isInt;
                boolean isShort;
                BigDecimal bdv = bd.stripTrailingZeros();
                dataTypeFound = true;
                if (this.schemaRow.get(j) != null) {
                    if (bdv.scale() > 0 && this.schemaRow.get(j) instanceof GenericNumericDataType) {
                        if (!(this.schemaRow.get(j) instanceof GenericBigDecimalDataType)) {
                            this.schemaRow.set(j, new GenericBigDecimalDataType(bdv.precision(), bdv.scale()));
                        } else if (bdv.scale() > ((GenericBigDecimalDataType)this.schemaRow.get(j)).getScale() && bdv.precision() > ((GenericBigDecimalDataType)this.schemaRow.get(j)).getPrecision()) {
                            this.schemaRow.set(j, new GenericBigDecimalDataType(bdv.precision(), bdv.scale()));
                        } else if (bdv.scale() > ((GenericBigDecimalDataType)this.schemaRow.get(j)).getScale()) {
                            GenericBigDecimalDataType gbd = (GenericBigDecimalDataType)this.schemaRow.get(j);
                            gbd.setScale(bdv.scale());
                            this.schemaRow.set(j, gbd);
                        } else if (bdv.precision() > ((GenericBigDecimalDataType)this.schemaRow.get(j)).getPrecision()) {
                            GenericBigDecimalDataType gbd = (GenericBigDecimalDataType)this.schemaRow.get(j);
                            int newpre = bdv.precision() + (gbd.getScale() - bdv.scale());
                            gbd.setPrecision(newpre);
                            this.schemaRow.set(j, gbd);
                        }
                    } else {
                        boolean isByte = false;
                        isShort = false;
                        isInt = false;
                        isLong = true;
                        try {
                            bdv.longValueExact();
                            isLong = true;
                            bdv.intValueExact();
                            isInt = true;
                            bdv.shortValueExact();
                            isShort = true;
                            bdv.byteValueExact();
                            isByte = true;
                        }
                        catch (Exception e) {
                            LOG.debug((Object)("Possible data types: Long: " + isLong + " Int: " + isInt + " Short: " + isShort + " Byte: " + isByte));
                        }
                        if (!(isByte && (this.schemaRow.get(j) instanceof GenericByteDataType || this.schemaRow.get(j) instanceof GenericShortDataType || this.schemaRow.get(j) instanceof GenericIntegerDataType || this.schemaRow.get(j) instanceof GenericLongDataType))) {
                            if (isShort && this.schemaRow.get(j) instanceof GenericByteDataType) {
                                this.schemaRow.set(j, new GenericShortDataType());
                            } else if (isInt && (this.schemaRow.get(j) instanceof GenericShortDataType || this.schemaRow.get(j) instanceof GenericByteDataType)) {
                                this.schemaRow.set(j, new GenericIntegerDataType());
                            } else if (!(isByte || isShort || isInt || this.schemaRow.get(j) instanceof GenericLongDataType)) {
                                this.schemaRow.set(j, new GenericLongDataType());
                            }
                        }
                    }
                } else if (bdv.scale() > 0) {
                    this.schemaRow.set(j, new GenericBigDecimalDataType(bdv.precision(), bdv.scale()));
                } else {
                    boolean isByte = false;
                    isShort = false;
                    isInt = false;
                    isLong = true;
                    try {
                        bdv.longValueExact();
                        isLong = true;
                        bdv.intValueExact();
                        isInt = true;
                        bdv.shortValueExact();
                        isShort = true;
                        bdv.byteValueExact();
                        isByte = true;
                    }
                    catch (Exception e) {
                        LOG.debug((Object)("Possible data types: Long: " + isLong + " Int: " + isInt + " Short: " + isShort + " Byte: " + isByte));
                    }
                    if (isByte) {
                        this.schemaRow.set(j, new GenericByteDataType());
                    } else if (isShort) {
                        this.schemaRow.set(j, new GenericShortDataType());
                    } else if (isInt) {
                        this.schemaRow.set(j, new GenericIntegerDataType());
                    } else if (isLong) {
                        this.schemaRow.set(j, new GenericLongDataType());
                    }
                }
            }
            if (dataTypeFound || this.schemaRow.get(j) instanceof GenericStringDataType) continue;
            this.schemaRow.set(j, new GenericStringDataType());
        }
    }

    public GenericDataType[] getSchemaRow() {
        GenericDataType[] result = new GenericDataType[this.schemaRow.size()];
        this.schemaRow.toArray(result);
        return result;
    }

    public void setSchemaRow(GenericDataType[] schemaRow) {
        this.schemaRow = new ArrayList<GenericDataType>(Arrays.asList(schemaRow));
    }

    public Object[] getDataAccordingToSchema(SpreadSheetCellDAO[] dataRow) {
        int i;
        if (dataRow == null) {
            return new Object[this.schemaRow.size()];
        }
        if (dataRow.length > this.schemaRow.size()) {
            LOG.warn((Object)"Data row is larger than schema. Will return String for everything that is not specified. ");
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (i = 0; i < this.schemaRow.size(); ++i) {
            returnList.add(null);
        }
        for (i = 0; i < dataRow.length; ++i) {
            SpreadSheetCellDAO currentCell = dataRow[i];
            if (currentCell == null) continue;
            int j = new CellAddress(currentCell.getAddress()).getColumn();
            if (j >= returnList.size()) {
                for (int x = returnList.size(); x <= j; ++x) {
                    returnList.add(null);
                }
            }
            GenericDataType applyDataType = null;
            if (j >= this.schemaRow.size()) {
                LOG.warn((Object)("No further schema row for column defined: " + String.valueOf(j) + ". Will assume String."));
            } else {
                applyDataType = this.schemaRow.get(j);
            }
            if (applyDataType == null) {
                returnList.set(j, currentCell.getFormattedValue());
                continue;
            }
            if (applyDataType instanceof GenericStringDataType) {
                returnList.set(j, currentCell.getFormattedValue());
                continue;
            }
            if (applyDataType instanceof GenericBooleanDataType) {
                if ("".equals(currentCell.getFormattedValue()) || !currentCell.getFormattedValue().equalsIgnoreCase("true") && !currentCell.getFormattedValue().equalsIgnoreCase("false")) continue;
                returnList.set(j, Boolean.valueOf(currentCell.getFormattedValue()));
                continue;
            }
            if (applyDataType instanceof GenericTimestampDataType) {
                Date theDate;
                if ("".equals(currentCell.getFormattedValue())) continue;
                boolean timestampFound = false;
                if (this.dateTimeFormat != null) {
                    theDate = this.dateTimeFormat.parse(currentCell.getFormattedValue(), new ParsePosition(0));
                    if (theDate != null) {
                        returnList.set(j, new Timestamp(theDate.getTime()));
                        timestampFound = true;
                    } else {
                        returnList.set(j, null);
                        LOG.warn((Object)("Could not identify timestamp using Date.parse using provided dateTime format. Trying Timestamp.valueOf. Original value: " + currentCell.getFormattedValue()));
                    }
                }
                if (!timestampFound) {
                    try {
                        returnList.set(j, Timestamp.valueOf(currentCell.getFormattedValue()));
                        timestampFound = true;
                    }
                    catch (IllegalArgumentException e) {
                        returnList.set(j, null);
                        LOG.warn((Object)("Could not identify timestamp using TimeStamp.valueOf. Trying last resort Date parsing. Original value: " + currentCell.getFormattedValue()));
                    }
                }
                if (timestampFound) continue;
                theDate = this.dateFormat.parse(currentCell.getFormattedValue(), new ParsePosition(0));
                if (theDate != null) {
                    returnList.set(j, new Timestamp(theDate.getTime()));
                    continue;
                }
                returnList.set(j, null);
                LOG.warn((Object)"Could not identify timestamp using Date.parse using provided date format");
                continue;
            }
            if (applyDataType instanceof GenericDateDataType) {
                if ("".equals(currentCell.getFormattedValue())) continue;
                Date theDate = this.dateFormat.parse(currentCell.getFormattedValue(), new ParsePosition(0));
                if (theDate != null) {
                    returnList.set(j, theDate);
                    continue;
                }
                returnList.set(j, null);
                continue;
            }
            if (applyDataType instanceof GenericNumericDataType) {
                if ("".equals(currentCell.getFormattedValue())) continue;
                BigDecimal bd = null;
                try {
                    if (!"".equals(currentCell.getFormattedValue())) {
                        if (currentCell.getFormattedValue().toUpperCase().contains("E")) {
                            String sanitizedCellContent = currentCell.getFormattedValue().replace(",", ".");
                            bd = new BigDecimal(sanitizedCellContent);
                        } else {
                            bd = (BigDecimal)this.decimalFormat.parse(currentCell.getFormattedValue());
                        }
                    }
                }
                catch (ParseException p) {
                    LOG.warn((Object)"Could not parse decimal in spreadsheet cell, although type was detected as decimal");
                }
                if (bd == null) continue;
                BigDecimal bdv = bd.stripTrailingZeros();
                if (applyDataType instanceof GenericByteDataType) {
                    returnList.set(j, bdv.byteValueExact());
                    continue;
                }
                if (applyDataType instanceof GenericShortDataType) {
                    returnList.set(j, bdv.shortValueExact());
                    continue;
                }
                if (applyDataType instanceof GenericIntegerDataType) {
                    returnList.set(j, bdv.intValueExact());
                    continue;
                }
                if (applyDataType instanceof GenericLongDataType) {
                    returnList.set(j, bdv.longValueExact());
                    continue;
                }
                if (applyDataType instanceof GenericDoubleDataType) {
                    returnList.set(j, bdv.doubleValue());
                    continue;
                }
                if (applyDataType instanceof GenericFloatDataType) {
                    returnList.set(j, Float.valueOf(bdv.floatValue()));
                    continue;
                }
                if (applyDataType instanceof GenericBigDecimalDataType) {
                    returnList.set(j, bd);
                    continue;
                }
                returnList.set(j, null);
                continue;
            }
            returnList.set(j, null);
            LOG.warn((Object)"Could not convert object in spreadsheet cellrow. Did you add a new datatype?");
        }
        Object[] result = new Object[returnList.size()];
        returnList.toArray(result);
        return result;
    }

    public SpreadSheetCellDAO[] getSpreadSheetCellDAOfromSimpleDataType(Object[] row, String sheetName, int rowNum) {
        SpreadSheetCellDAO[] result = new SpreadSheetCellDAO[row.length];
        for (int currentColumnNum = 0; currentColumnNum < row.length; ++currentColumnNum) {
            Object x = row[currentColumnNum];
            String formattedValue = "";
            String comment = "";
            String formula = "";
            String address = "";
            StringBuffer sb = new StringBuffer();
            if (x == null) continue;
            if (x instanceof SpreadSheetCellDAO) {
                result[currentColumnNum] = (SpreadSheetCellDAO)x;
                continue;
            }
            if (x instanceof Boolean) {
                formattedValue = "";
                comment = "";
                formula = String.valueOf(x);
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Byte) {
                formattedValue = "";
                comment = "";
                formula = String.valueOf(x);
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Short) {
                formattedValue = "";
                comment = "";
                formula = "";
                formula = String.valueOf(x);
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Integer) {
                formattedValue = "";
                comment = "";
                formula = String.valueOf(x);
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Long) {
                formattedValue = "";
                comment = "";
                formula = String.valueOf(x);
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Double) {
                formattedValue = "";
                comment = "";
                formula = String.valueOf(x);
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Float) {
                formattedValue = "";
                comment = "";
                formula = String.valueOf(x);
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof BigDecimal) {
                formattedValue = "";
                comment = "";
                formula = ((BigDecimal)x).toString();
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Timestamp) {
                if (this.dateTimeFormat == null) {
                    formattedValue = String.valueOf(x);
                } else {
                    formattedValue = this.dateTimeFormat.format(x, sb, new FieldPosition(0)).toString();
                    sb.setLength(0);
                }
                comment = "";
                formula = "";
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof Date) {
                formattedValue = this.dateFormat.format((Date)x);
                comment = "";
                formula = "";
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof String) {
                formattedValue = x.toString();
                comment = "";
                formula = "";
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            } else if (x instanceof String[] && ((String[])x).length == 5) {
                String[] spreadSheetCellDAOAsArray = (String[])x;
                formattedValue = spreadSheetCellDAOAsArray[0];
                comment = spreadSheetCellDAOAsArray[1];
                formula = spreadSheetCellDAOAsArray[2];
                address = spreadSheetCellDAOAsArray[3];
                sheetName = spreadSheetCellDAOAsArray[4];
            } else {
                LOG.warn((Object)("Unknown datatype in column number: " + currentColumnNum + ". Reported data type" + x.getClass().getName() + ". Trying to use .toString"));
                formattedValue = x.toString();
                comment = "";
                formula = "";
                address = MSExcelUtil.getCellAddressA1Format(rowNum, currentColumnNum);
            }
            result[currentColumnNum] = new SpreadSheetCellDAO(formattedValue, comment, formula, address, sheetName);
        }
        return result;
    }
}

