/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.hadoop.office.format.common.writer.msexcel.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.util.TempFile;

public class EncryptedTempData {
    private static final Log LOG = LogFactory.getLog((String)EncryptedTempData.class.getName());
    private CipherAlgorithm ca;
    private ChainingMode cm;
    private Cipher ciEncrypt;
    private Cipher ciDecrypt;
    private File tempFile;

    public EncryptedTempData(CipherAlgorithm ca, ChainingMode cm) throws IOException {
        if (ca != null) {
            SecureRandom sr = new SecureRandom();
            byte[] iv = new byte[ca.blockSize];
            byte[] key = new byte[ca.defaultKeySize / 8];
            sr.nextBytes(iv);
            sr.nextBytes(key);
            SecretKeySpec skeySpec = new SecretKeySpec(key, ca.jceId);
            this.ca = ca;
            this.cm = cm;
            if (this.cm.jceId.equals(ChainingMode.ecb.jceId)) {
                this.cm = ChainingMode.cbc;
            }
            this.ciEncrypt = CryptoFunctions.getCipher(skeySpec, ca, cm, iv, 1, "PKCS5Padding");
            this.ciDecrypt = CryptoFunctions.getCipher(skeySpec, ca, cm, iv, 2, "PKCS5Padding");
        }
        this.tempFile = TempFile.createTempFile("hadooffice-poi-temp-data", ".tmp");
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        if (this.ciEncrypt != null) {
            LOG.debug((Object)("Returning encrypted OutputStream for " + this.tempFile.getAbsolutePath()));
            return new CipherOutputStream(new FileOutputStream(this.tempFile), this.ciEncrypt);
        }
        return new FileOutputStream(this.tempFile);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.ciDecrypt != null) {
            LOG.debug((Object)("Returning decrypted InputStream for " + this.tempFile.getAbsolutePath()));
            LOG.debug((Object)("Size of temp file: " + this.tempFile.length()));
            return new CipherInputStream(new FileInputStream(this.tempFile), this.ciDecrypt);
        }
        return new FileInputStream(this.tempFile);
    }

    public void dispose() {
        if (!this.tempFile.delete()) {
            LOG.warn((Object)"Could not delete temporary files");
        }
    }
}

