/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.DelegateRecordReaderFactory;
import com.google.cloud.hadoop.io.bigquery.Export;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.HadoopConfigurationProperty;
import com.google.cloud.hadoop.io.bigquery.NoopFederatedExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.UnshardedExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.cloud.hadoop.util.HadoopToStringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class AbstractBigQueryInputFormat<K, V>
extends InputFormat<K, V>
implements DelegateRecordReaderFactory<K, V> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final HadoopConfigurationProperty<Class<?>> INPUT_FORMAT_CLASS = new HadoopConfigurationProperty<Class<AbstractBigQueryInputFormat>>("mapreduce.inputformat.class", AbstractBigQueryInputFormat.class, new String[0]);
    public static final String EXTERNAL_TABLE_TYPE = "EXTERNAL";
    private InputFormat<LongWritable, Text> delegateInputFormat;

    public static void setInputTable(Configuration configuration, String projectId, String datasetId, String tableId) throws IOException {
        BigQueryConfiguration.configureBigQueryInput(configuration, projectId, datasetId, tableId);
    }

    public static void setInputTable(Configuration configuration, TableReference tableReference) throws IOException {
        AbstractBigQueryInputFormat.setInputTable(configuration, tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
    }

    public static void setTemporaryCloudStorageDirectory(Configuration configuration, String path) {
        configuration.set(BigQueryConfiguration.TEMP_GCS_PATH.getKey(), path);
    }

    public abstract ExportFileFormat getExportFileFormat();

    protected static ExportFileFormat getExportFileFormat(Configuration configuration) {
        Class clazz = (Class)INPUT_FORMAT_CLASS.get(configuration, (arg_0, arg_1) -> ((Configuration)configuration).getClass(arg_0, arg_1));
        Preconditions.checkState((boolean)AbstractBigQueryInputFormat.class.isAssignableFrom(clazz), (Object)"Expected input format to derive from AbstractBigQueryInputFormat");
        return AbstractBigQueryInputFormat.getExportFileFormat(clazz);
    }

    protected static ExportFileFormat getExportFileFormat(Class<? extends AbstractBigQueryInputFormat<?, ?>> clazz) {
        try {
            AbstractBigQueryInputFormat<?, ?> format = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return format.getExportFileFormat();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        BigQueryHelper bigQueryHelper;
        ((GoogleLogger.Api)logger.atFine()).log("getSplits(%s)", (Object)LazyArgs.lazy(() -> HadoopToStringUtil.toString((JobContext)context)));
        Configuration configuration = context.getConfiguration();
        try {
            bigQueryHelper = this.getBigQueryHelper(configuration);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create BigQuery client", gse);
        }
        String exportPath = BigQueryConfiguration.getTemporaryPathRoot(configuration, context.getJobID());
        configuration.set(BigQueryConfiguration.TEMP_GCS_PATH.getKey(), exportPath);
        Export export = AbstractBigQueryInputFormat.constructExport(configuration, this.getExportFileFormat(), exportPath, bigQueryHelper, this.delegateInputFormat);
        export.prepare();
        try {
            export.beginExport();
            export.waitForUsableMapReduceInput();
        }
        catch (IOException ie) {
            throw new IOException("Error while exporting: " + HadoopToStringUtil.toString((JobContext)context), ie);
        }
        List<InputSplit> splits = export.getSplits(context);
        if (((GoogleLogger.Api)logger.atFine()).isEnabled()) {
            ((GoogleLogger.Api)logger.atFine()).log("getSplits -> %s", (Object)HadoopToStringUtil.toString(splits));
        }
        return splits;
    }

    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return this.createRecordReader(inputSplit, taskAttemptContext.getConfiguration());
    }

    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, Configuration configuration) throws IOException, InterruptedException {
        Preconditions.checkArgument((boolean)(inputSplit instanceof UnshardedInputSplit), (Object)"Split should be instance of UnshardedInputSplit.");
        ((GoogleLogger.Api)logger.atFine()).log("createRecordReader -> createDelegateRecordReader()");
        return this.createDelegateRecordReader(inputSplit, configuration);
    }

    private static Export constructExport(Configuration configuration, ExportFileFormat format, String exportPath, BigQueryHelper bigQueryHelper, InputFormat<LongWritable, Text> delegateInputFormat) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("constructExport() with export path %s", (Object)exportPath);
        Map mandatoryConfig = ConfigurationUtil.getMandatoryConfig((Configuration)configuration, BigQueryConfiguration.MANDATORY_CONFIG_PROPERTIES_INPUT);
        String jobProjectId = (String)mandatoryConfig.get(BigQueryConfiguration.PROJECT_ID.getKey());
        String inputProjectId = (String)mandatoryConfig.get(BigQueryConfiguration.INPUT_PROJECT_ID.getKey());
        String datasetId = (String)mandatoryConfig.get(BigQueryConfiguration.INPUT_DATASET_ID.getKey());
        String tableName = (String)mandatoryConfig.get(BigQueryConfiguration.INPUT_TABLE_ID.getKey());
        TableReference exportTableReference = new TableReference().setDatasetId(datasetId).setProjectId(inputProjectId).setTableId(tableName);
        Table table = bigQueryHelper.getTable(exportTableReference);
        if (EXTERNAL_TABLE_TYPE.equals(table.getType())) {
            ((GoogleLogger.Api)logger.atInfo()).log("Table is already external, so skipping export");
            return new NoopFederatedExportToCloudStorage(configuration, format, bigQueryHelper, jobProjectId, table, delegateInputFormat);
        }
        return new UnshardedExportToCloudStorage(configuration, exportPath, format, bigQueryHelper, jobProjectId, table, delegateInputFormat);
    }

    public static void cleanupJob(Configuration configuration, JobID jobId) throws IOException {
        Bigquery bigquery;
        String exportPathRoot = BigQueryConfiguration.getTemporaryPathRoot(configuration, jobId);
        configuration.set(BigQueryConfiguration.TEMP_GCS_PATH.getKey(), exportPathRoot);
        try {
            bigquery = new BigQueryFactory().getBigQuery(configuration);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create Bigquery client", gse);
        }
        AbstractBigQueryInputFormat.cleanupJob(new BigQueryHelper(bigquery), configuration);
    }

    public static void cleanupJob(BigQueryHelper bigQueryHelper, Configuration config) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("cleanupJob(Bigquery, Configuration)");
        String gcsPath = ConfigurationUtil.getMandatoryConfig((Configuration)config, BigQueryConfiguration.TEMP_GCS_PATH);
        Export export = AbstractBigQueryInputFormat.constructExport(config, AbstractBigQueryInputFormat.getExportFileFormat(config), gcsPath, bigQueryHelper, null);
        try {
            export.cleanupExport();
        }
        catch (IOException ioe) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)ioe)).log("Could not delete intermediate data from BigQuery export");
        }
    }

    protected Bigquery getBigQuery(Configuration config) throws GeneralSecurityException, IOException {
        BigQueryFactory factory = new BigQueryFactory();
        return factory.getBigQuery(config);
    }

    protected BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
        BigQueryFactory factory = new BigQueryFactory();
        return factory.getBigQueryHelper(config);
    }

    @VisibleForTesting
    void setDelegateInputFormat(InputFormat inputFormat) {
        this.delegateInputFormat = inputFormat;
    }
}

