/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.Export;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class AbstractExportToCloudStorage
implements Export {
    public static final String DESTINATION_FORMAT_KEY = "destinationFormat";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    protected final Configuration configuration;
    protected final String gcsPath;
    protected final ExportFileFormat fileFormat;
    protected final BigQueryHelper bigQueryHelper;
    protected final String projectId;
    protected final Table tableToExport;
    protected JobReference exportJobReference;

    public AbstractExportToCloudStorage(Configuration configuration, String gcsPath, ExportFileFormat fileFormat, BigQueryHelper bigQueryHelper, String projectId, Table tableToExport) {
        this.configuration = configuration;
        this.gcsPath = gcsPath;
        this.fileFormat = fileFormat;
        this.bigQueryHelper = bigQueryHelper;
        this.projectId = projectId;
        this.tableToExport = tableToExport;
    }

    @Override
    public void prepare() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("Preparing export path %s", (Object)this.gcsPath);
        Path hadoopPath = new Path(this.gcsPath);
        FileSystem fs = hadoopPath.getFileSystem(this.configuration);
        if (fs.exists(hadoopPath)) {
            throw new IOException(String.format("Conflict occurred creating export directory. Path %s already exists", this.gcsPath));
        }
        fs.mkdirs(hadoopPath);
    }

    @Override
    public void beginExport() throws IOException {
        JobConfigurationExtract extractConfig = new JobConfigurationExtract();
        extractConfig.setSourceTable(this.tableToExport.getTableReference());
        extractConfig.setDestinationUris(this.getExportPaths());
        extractConfig.set(DESTINATION_FORMAT_KEY, (Object)this.fileFormat.getFormatIdentifier());
        JobConfiguration config = new JobConfiguration();
        config.setExtract(extractConfig);
        JobReference jobReference = this.bigQueryHelper.createJobReference(this.projectId, "exporttocloudstorage", this.tableToExport.getLocation());
        Job job = new Job();
        job.setConfiguration(config);
        job.setJobReference(jobReference);
        try {
            Job response = this.bigQueryHelper.insertJobOrFetchDuplicate(this.projectId, job);
            ((GoogleLogger.Api)logger.atFine()).log("Got response '%s'", (Object)response);
            this.exportJobReference = response.getJobReference();
        }
        catch (IOException e) {
            String error = String.format("Error while exporting table %s", BigQueryStrings.toString(this.tableToExport.getTableReference()));
            throw new IOException(error, e);
        }
    }

    @Override
    public void cleanupExport() throws IOException {
        if (((Boolean)BigQueryConfiguration.DELETE_EXPORT_FILES_FROM_GCS.get(this.configuration, (arg_0, arg_1) -> ((Configuration)this.configuration).getBoolean(arg_0, arg_1))).booleanValue()) {
            Path tempPath = new Path(ConfigurationUtil.getMandatoryConfig((Configuration)this.configuration, BigQueryConfiguration.TEMP_GCS_PATH));
            try {
                FileSystem fs = tempPath.getFileSystem(this.configuration);
                if (fs.exists(tempPath)) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Deleting temp GCS input path '%s'", (Object)tempPath);
                    fs.delete(tempPath, true);
                }
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Could not delete intermediate GCS files. Temporary data not cleaned up.");
            }
        }
    }
}

