/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.HadoopConfigurationProperty;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;

public class BigQueryConfiguration {
    public static final String BIGQUERY_CONFIG_PREFIX = "mapred.bq";
    public static final HadoopConfigurationProperty<String> BQ_ROOT_URL = new HadoopConfigurationProperty<String>("mapred.bq.bigquery.root.url", "https://bigquery.googleapis.com/", new String[0]);
    public static final HadoopConfigurationProperty<String> PROJECT_ID = new HadoopConfigurationProperty("mapred.bq.project.id");
    public static final HadoopConfigurationProperty<String> INPUT_PROJECT_ID = new HadoopConfigurationProperty("mapred.bq.input.project.id");
    public static final HadoopConfigurationProperty<String> INPUT_DATASET_ID = new HadoopConfigurationProperty("mapred.bq.input.dataset.id");
    public static final HadoopConfigurationProperty<String> INPUT_TABLE_ID = new HadoopConfigurationProperty("mapred.bq.input.table.id");
    public static final HadoopConfigurationProperty<String> TEMP_GCS_PATH = new HadoopConfigurationProperty("mapred.bq.temp.gcs.path");
    public static final HadoopConfigurationProperty<String> GCS_BUCKET = new HadoopConfigurationProperty("mapred.bq.gcs.bucket");
    public static final HadoopConfigurationProperty<Boolean> DELETE_EXPORT_FILES_FROM_GCS = new HadoopConfigurationProperty<Boolean>("mapred.bq.input.export.files.delete", true, new String[0]);
    public static final HadoopConfigurationProperty<Integer> DYNAMIC_FILE_LIST_RECORD_READER_POLL_INTERVAL_MS = new HadoopConfigurationProperty<Integer>("mapred.bq.dynamic.file.list.record.reader.poll.interval", 10000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> DYNAMIC_FILE_LIST_RECORD_READER_POLL_MAX_ATTEMPTS = new HadoopConfigurationProperty<Integer>("mapred.bq.dynamic.file.list.record.reader.poll.max.attempts", -1, new String[0]);
    public static final List<HadoopConfigurationProperty<?>> MANDATORY_CONFIG_PROPERTIES_INPUT = ImmutableList.of(PROJECT_ID, INPUT_PROJECT_ID, INPUT_DATASET_ID, INPUT_TABLE_ID);
    public static final HadoopConfigurationProperty<String> OUTPUT_PROJECT_ID = new HadoopConfigurationProperty("mapred.bq.output.project.id");
    public static final HadoopConfigurationProperty<String> OUTPUT_DATASET_ID = new HadoopConfigurationProperty("mapred.bq.output.dataset.id");
    public static final HadoopConfigurationProperty<String> OUTPUT_TABLE_ID = new HadoopConfigurationProperty("mapred.bq.output.table.id");
    public static final HadoopConfigurationProperty<String> OUTPUT_TABLE_SCHEMA = new HadoopConfigurationProperty("mapred.bq.output.table.schema");
    public static final HadoopConfigurationProperty<String> OUTPUT_TABLE_PARTITIONING = new HadoopConfigurationProperty("mapred.bq.output.table.partitioning");
    public static final HadoopConfigurationProperty<String> OUTPUT_TABLE_KMS_KEY_NAME = new HadoopConfigurationProperty("mapred.bq.output.table.kmskeyname");
    public static final HadoopConfigurationProperty<String> OUTPUT_TABLE_WRITE_DISPOSITION = new HadoopConfigurationProperty<String>("mapred.bq.output.table.writedisposition", "WRITE_APPEND", new String[0]);
    public static final HadoopConfigurationProperty<String> OUTPUT_TABLE_CREATE_DISPOSITION = new HadoopConfigurationProperty<String>("mapred.bq.output.table.createdisposition", "CREATE_IF_NEEDED", new String[0]);
    public static final HadoopConfigurationProperty<String> OUTPUT_FILE_FORMAT = new HadoopConfigurationProperty("mapred.bq.output.gcs.fileformat");
    public static final HadoopConfigurationProperty<Class<?>> OUTPUT_FORMAT_CLASS = new HadoopConfigurationProperty("mapred.bq.output.gcs.outputformatclass");
    public static final HadoopConfigurationProperty<Boolean> OUTPUT_CLEANUP_TEMP = new HadoopConfigurationProperty<Boolean>("mapred.bq.output.gcs.cleanup", true, new String[0]);
    public static final HadoopConfigurationProperty<Integer> OUTPUT_WRITE_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("mapred.bq.output.buffer.size", 0x4000000, new String[0]);
    public static final HadoopConfigurationProperty<String> DATA_LOCATION = new HadoopConfigurationProperty<String>("mapred.bq.output.location", "US", new String[0]);
    public static final HadoopConfigurationProperty<String> SQL_FILTER = new HadoopConfigurationProperty<String>("mapred.bq.input.sql.filter", "", new String[0]);
    public static final HadoopConfigurationProperty<String> SELECTED_FIELDS = new HadoopConfigurationProperty("mapred.bq.input.selected.fields");
    public static final HadoopConfigurationProperty<Double> SKEW_LIMIT = new HadoopConfigurationProperty<Double>("mapred.bq.input.skew.limit", 1.5, new String[0]);
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static void configureBigQueryInput(Configuration config, String projectId, String datasetId, String tableId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)datasetId) ? 1 : 0) != 0, (Object)"datasetId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableId) ? 1 : 0) != 0, (Object)"tableId must not be null or empty.");
        if (!Strings.isNullOrEmpty((String)projectId)) {
            ((GoogleLogger.Api)logger.atInfo()).log("Using specified project-id '%s' for input", (Object)projectId);
            config.set(INPUT_PROJECT_ID.getKey(), projectId);
            if (Strings.isNullOrEmpty((String)((String)PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))))) {
                ((GoogleLogger.Api)logger.atWarning()).log("No job-level projectId specified in '%s', using '%s' for it.", (Object)PROJECT_ID.getKey(), (Object)projectId);
                config.set(PROJECT_ID.getKey(), projectId);
            }
        } else {
            String defaultProjectId = ConfigurationUtil.getMandatoryConfig((Configuration)config, PROJECT_ID);
            ((GoogleLogger.Api)logger.atInfo()).log("Using default project-id '%s' since none specified for input.", (Object)defaultProjectId);
            config.set(INPUT_PROJECT_ID.getKey(), defaultProjectId);
        }
        config.set(INPUT_DATASET_ID.getKey(), datasetId);
        config.set(INPUT_TABLE_ID.getKey(), tableId);
    }

    public static void configureBigQueryInput(Configuration config, String fullyQualifiedInputTableId) throws IOException {
        TableReference parsedTable = BigQueryStrings.parseTableReference(fullyQualifiedInputTableId);
        BigQueryConfiguration.configureBigQueryInput(config, parsedTable.getProjectId(), parsedTable.getDatasetId(), parsedTable.getTableId());
    }

    public static void configureBigQueryOutput(Configuration config, String projectId, String datasetId, String tableId, String tableSchema) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)datasetId) ? 1 : 0) != 0, (Object)"datasetId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableId) ? 1 : 0) != 0, (Object)"tableId must not be null or empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableSchema) ? 1 : 0) != 0, (Object)"tableSchema must not be null or empty.");
        if (!Strings.isNullOrEmpty((String)projectId)) {
            ((GoogleLogger.Api)logger.atInfo()).log("Using specified project-id '%s' for output", (Object)projectId);
            config.set(OUTPUT_PROJECT_ID.getKey(), projectId);
            if (Strings.isNullOrEmpty((String)((String)PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))))) {
                ((GoogleLogger.Api)logger.atWarning()).log("No job-level projectId specified in '%s', using '%s' for it.", (Object)PROJECT_ID.getKey(), (Object)projectId);
                config.set(PROJECT_ID.getKey(), projectId);
            }
        } else {
            String defaultProjectId = ConfigurationUtil.getMandatoryConfig((Configuration)config, PROJECT_ID);
            ((GoogleLogger.Api)logger.atInfo()).log("Using default project-id '%s' since none specified for output.", (Object)defaultProjectId);
            config.set(OUTPUT_PROJECT_ID.getKey(), defaultProjectId);
        }
        config.set(OUTPUT_DATASET_ID.getKey(), datasetId);
        config.set(OUTPUT_TABLE_ID.getKey(), tableId);
        config.set(OUTPUT_TABLE_SCHEMA.getKey(), tableSchema);
    }

    public static void configureBigQueryOutput(Configuration config, String fullyQualifiedOutputTableId, String tableSchema) throws IOException {
        TableReference parsedTable = BigQueryStrings.parseTableReference(fullyQualifiedOutputTableId);
        BigQueryConfiguration.configureBigQueryOutput(config, parsedTable.getProjectId(), parsedTable.getDatasetId(), parsedTable.getTableId(), tableSchema);
    }

    public static String getTemporaryPathRoot(Configuration conf, @Nullable JobID jobId) throws IOException {
        String pathRoot = conf.get(TEMP_GCS_PATH.getKey());
        if (Strings.isNullOrEmpty((String)pathRoot)) {
            Preconditions.checkNotNull((Object)jobId, (String)"jobId is required if '%s' is not set", (Object)TEMP_GCS_PATH.getKey());
            ((GoogleLogger.Api)logger.atInfo()).log("Fetching key '%s' since '%s' isn't set explicitly.", (Object)GCS_BUCKET.getKey(), (Object)TEMP_GCS_PATH.getKey());
            String gcsBucket = conf.get(GCS_BUCKET.getKey());
            if (Strings.isNullOrEmpty((String)gcsBucket)) {
                throw new IOException("Must supply a value for configuration setting: " + GCS_BUCKET.getKey());
            }
            pathRoot = String.format("gs://%s/hadoop/tmp/bigquery/%s", gcsBucket, jobId);
        }
        ((GoogleLogger.Api)logger.atInfo()).log("Using working path: '%s'", (Object)pathRoot);
        Path workingPath = new Path(pathRoot);
        FileSystem fs = workingPath.getFileSystem(conf);
        Preconditions.checkState((boolean)"gs".equals(fs.getScheme()), (Object)"Export FS must be GCS ('gs' scheme).");
        return pathRoot;
    }
}

