/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.util.HadoopToStringUtil;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class GsonRecordReader
extends RecordReader<LongWritable, JsonObject> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private LineRecordReader lineReader;
    private LongWritable currentKey = new LongWritable(0L);
    private JsonObject currentValue;
    private int count;
    private JsonParser jsonParser;

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        if (((GoogleLogger.Api)logger.atFine()).isEnabled()) {
            ((GoogleLogger.Api)logger.atFine()).log("initialize('%s', '%s')", (Object)HadoopToStringUtil.toString((InputSplit)genericSplit), (Object)HadoopToStringUtil.toString((TaskAttemptContext)context));
        }
        Preconditions.checkArgument((boolean)(genericSplit instanceof FileSplit), (Object)"InputSplit genericSplit should be an instance of FileSplit.");
        FileSplit fileSplit = (FileSplit)genericSplit;
        this.jsonParser = new JsonParser();
        this.lineReader = new LineRecordReader();
        this.lineReader.initialize((InputSplit)fileSplit, context);
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.lineReader.nextKeyValue()) {
            ((GoogleLogger.Api)logger.atFine()).log("All values read: record reader read %s key, value pairs.", this.count);
            return false;
        }
        this.currentKey.set(this.lineReader.getCurrentKey().get());
        Text lineValue = this.lineReader.getCurrentValue();
        this.currentValue = this.jsonParser.parse(lineValue.toString()).getAsJsonObject();
        ++this.count;
        return true;
    }

    public LongWritable getCurrentKey() {
        return this.currentKey;
    }

    public JsonObject getCurrentValue() {
        return this.currentValue;
    }

    public float getProgress() throws IOException {
        return this.lineReader.getProgress();
    }

    public void close() throws IOException {
        this.lineReader.close();
    }
}

