/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;

public class BigQueryTableFieldSchema {
    private final TableFieldSchema fieldSchema;

    public BigQueryTableFieldSchema() {
        this.fieldSchema = new TableFieldSchema();
    }

    BigQueryTableFieldSchema(TableFieldSchema fieldSchema) {
        Preconditions.checkNotNull((Object)fieldSchema);
        this.fieldSchema = fieldSchema;
    }

    public String getMode() {
        return this.fieldSchema.getMode();
    }

    public BigQueryTableFieldSchema setMode(String mode) {
        this.fieldSchema.setMode(mode);
        return this;
    }

    public String getName() {
        return this.fieldSchema.getName();
    }

    public BigQueryTableFieldSchema setName(String name) {
        this.fieldSchema.setName(name);
        return this;
    }

    public String getType() {
        return this.fieldSchema.getType();
    }

    public BigQueryTableFieldSchema setType(String type) {
        this.fieldSchema.setType(type);
        return this;
    }

    public List<BigQueryTableFieldSchema> getFields() {
        return this.get().getFields().stream().map(BigQueryTableFieldSchema::new).collect(Collectors.toList());
    }

    public BigQueryTableFieldSchema setFields(List<BigQueryTableFieldSchema> fields) {
        this.fieldSchema.setFields(fields.stream().map(BigQueryTableFieldSchema::get).collect(Collectors.toList()));
        return this;
    }

    public int hashCode() {
        return this.fieldSchema.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigQueryTableFieldSchema)) {
            return false;
        }
        BigQueryTableFieldSchema another = (BigQueryTableFieldSchema)object;
        return this.fieldSchema.equals((Object)another.fieldSchema);
    }

    TableFieldSchema get() {
        return this.fieldSchema;
    }

    static BigQueryTableFieldSchema wrap(TableFieldSchema fieldSchema) {
        return new BigQueryTableFieldSchema(fieldSchema);
    }
}

