/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.ForwardingBigQueryFileOutputCommitter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceStability.Unstable
public class FederatedBigQueryOutputCommitter
extends ForwardingBigQueryFileOutputCommitter {
    public FederatedBigQueryOutputCommitter(TaskAttemptContext context, OutputCommitter delegate) throws IOException {
        super(context, delegate);
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        super.commitJob(context);
        Configuration conf = context.getConfiguration();
        TableReference destTable = BigQueryOutputConfiguration.getTableReference(conf);
        String jobProjectId = BigQueryOutputConfiguration.getJobProjectId(conf);
        Optional<BigQueryTableSchema> destSchema = BigQueryOutputConfiguration.getTableSchema(conf);
        BigQueryFileFormat outputFileFormat = BigQueryOutputConfiguration.getFileFormat(conf);
        List<String> sourceUris = this.getOutputFileURIs();
        this.getBigQueryHelper().importFederatedFromGcs(jobProjectId, destTable, destSchema.isPresent() ? destSchema.get().get() : null, outputFileFormat, sourceUris);
    }

    @Override
    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        super.abortJob(context, state);
        this.cleanup(context);
    }
}

