/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceStability.Unstable
public class ForwardingBigQueryFileOutputCommitter
extends OutputCommitter {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final OutputCommitter delegate;
    private final FileSystem outputFileSystem;
    private final Path outputPath;
    private BigQueryHelper bigQueryHelper;

    public ForwardingBigQueryFileOutputCommitter(TaskAttemptContext context, OutputCommitter delegate) throws IOException {
        this.delegate = delegate;
        Configuration conf = context.getConfiguration();
        BigQueryOutputConfiguration.validateConfiguration(conf);
        Path path = BigQueryOutputConfiguration.getGcsOutputPath(conf);
        this.outputFileSystem = path.getFileSystem(conf);
        this.outputPath = this.outputFileSystem.makeQualified(path);
        try {
            this.bigQueryHelper = BigQueryFactory.INSTANCE.getBigQueryHelper(conf);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create BigQuery client", gse);
        }
    }

    public void commitJob(JobContext context) throws IOException {
        this.delegate.commitJob(context);
    }

    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        this.delegate.abortJob(context, state);
    }

    public void abortTask(TaskAttemptContext context) throws IOException {
        this.delegate.abortTask(context);
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        this.delegate.commitTask(context);
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.delegate.needsTaskCommit(context);
    }

    public void setupJob(JobContext context) throws IOException {
        this.delegate.setupJob(context);
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        this.delegate.setupTask(context);
    }

    protected List<String> getOutputFileURIs() throws IOException {
        FileStatus[] outputFiles = this.outputFileSystem.listStatus(this.outputPath);
        ArrayList<String> sourceUris = new ArrayList<String>(outputFiles.length);
        for (int i = 0; i < outputFiles.length; ++i) {
            FileStatus fileStatus = outputFiles[i];
            if (fileStatus.isDir() || fileStatus.getPath().getName().equals("_SUCCESS")) continue;
            sourceUris.add(fileStatus.getPath().toString());
        }
        return sourceUris;
    }

    protected void cleanup(JobContext context) throws IOException {
        boolean delete = BigQueryOutputConfiguration.getCleanupTemporaryDataFlag(context.getConfiguration());
        if (delete && this.outputFileSystem.exists(this.outputPath)) {
            ((GoogleLogger.Api)logger.atInfo()).log("Found GCS output data at '%s', attempting to clean up.", (Object)this.outputPath);
            if (this.outputFileSystem.delete(this.outputPath, true)) {
                ((GoogleLogger.Api)logger.atInfo()).log("Successfully deleted GCS output path '%s'.", (Object)this.outputPath);
            } else {
                ((GoogleLogger.Api)logger.atWarning()).log("Failed to delete GCS output at '%s', retrying on shutdown.", (Object)this.outputPath);
                this.outputFileSystem.deleteOnExit(this.outputPath);
            }
        }
    }

    protected OutputCommitter getDelegate() {
        return this.delegate;
    }

    protected BigQueryHelper getBigQueryHelper() {
        return this.bigQueryHelper;
    }

    @VisibleForTesting
    void setBigQueryHelper(BigQueryHelper bigQueryHelper) {
        this.bigQueryHelper = bigQueryHelper;
    }
}

