/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.samples;

import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.HadoopConfigurationProperty;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.IndirectBigQueryOutputFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class WordCount {
    public static final HadoopConfigurationProperty<String> WORDCOUNT_WORD_FIELDNAME = new HadoopConfigurationProperty<String>("mapred.bq.samples.wordcount.word.key", "word", new String[0]);

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser parser = new GenericOptionsParser(args);
        if ((args = parser.getRemainingArgs()).length != 5) {
            System.out.println("Usage: hadoop jar bigquery_wordcount.jar [ProjectId] [QualifiedInputTableId] [InputTableFieldName] [QualifiedOutputTableId] [GcsOutputPath]\n    ProjectId - Project under which to issue the BigQuery operations. Also serves as the default project for table IDs that don't explicitly specify a project for the table.\n    QualifiedInputTableId - Input table ID of the form (Optional ProjectId):[DatasetId].[TableId]\n    InputTableFieldName - Name of the field to count in the input table, e.g., 'word' in publicdata:samples.shakespeare or 'repository_name' in publicdata:samples.github_timeline.\n    QualifiedOutputTableId - Output table ID of the form (Optional ProjectId):[DatasetId].[TableId]\n    GcsOutputPath - The output path to store temporary Cloud Storage data, e.g., gs://bucket/dir/");
            System.exit(1);
        }
        String projectId = args[0];
        String inputQualifiedTableId = args[1];
        String inputTableFieldId = args[2];
        String outputQualifiedTableId = args[3];
        String outputGcsPath = args[4];
        BigQueryTableSchema outputSchema = new BigQueryTableSchema().setFields((List<BigQueryTableFieldSchema>)ImmutableList.of((Object)new BigQueryTableFieldSchema().setName("Word").setType("STRING"), (Object)new BigQueryTableFieldSchema().setName("Count").setType("INTEGER")));
        Job job = Job.getInstance((Configuration)parser.getConfiguration(), (String)"wordcount");
        Configuration conf = job.getConfiguration();
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), projectId);
        BigQueryConfiguration.configureBigQueryInput(conf, inputQualifiedTableId);
        BigQueryOutputConfiguration.configure(conf, outputQualifiedTableId, outputSchema, outputGcsPath, BigQueryFileFormat.NEWLINE_DELIMITED_JSON, TextOutputFormat.class);
        conf.set(WORDCOUNT_WORD_FIELDNAME.getKey(), inputTableFieldId);
        job.setJarByClass(WordCount.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(Map.class);
        job.setReducerClass(Reduce.class);
        job.setInputFormatClass(GsonBigQueryInputFormat.class);
        job.setOutputFormatClass(IndirectBigQueryOutputFormat.class);
        job.waitForCompletion(true);
        GsonBigQueryInputFormat.cleanupJob(job.getConfiguration(), job.getJobID());
    }

    public static class Reduce
    extends Reducer<Text, LongWritable, JsonObject, NullWritable> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long count = Streams.stream(values).mapToLong(LongWritable::get).sum();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Word", key.toString());
            jsonObject.addProperty("Count", (Number)count);
            context.write((Object)jsonObject, (Object)NullWritable.get());
        }
    }

    public static class Map
    extends Mapper<LongWritable, JsonObject, Text, LongWritable> {
        private static final LongWritable ONE = new LongWritable(1L);
        private Text word = new Text();
        private String wordKey;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.wordKey = (String)WORDCOUNT_WORD_FIELDNAME.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1));
        }

        public void map(LongWritable key, JsonObject value, Mapper.Context context) throws IOException, InterruptedException {
            JsonElement countElement = value.get(this.wordKey);
            if (countElement != null) {
                String wordInRecord = countElement.getAsString();
                this.word.set(wordInRecord);
                context.write((Object)this.word, (Object)ONE);
            }
        }
    }
}

