/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.GenericUrl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.json.JsonHttpContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonObjectParser;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.GenericData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.ServiceAccountSigner;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.http.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.IamUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.IdToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.IdTokenProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.OAuth2Utils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.Beta;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ImpersonatedCredentials
extends GoogleCredentials
implements ServiceAccountSigner,
IdTokenProvider {
    private static final long serialVersionUID = -2133257318957488431L;
    private static final String RFC3339 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final int ONE_HOUR_IN_SECONDS = 3600;
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final String IAM_ACCESS_TOKEN_ENDPOINT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateAccessToken";
    private static final String SCOPE_EMPTY_ERROR = "Scopes cannot be null";
    private static final String LIFETIME_EXCEEDED_ERROR = "lifetime must be less than or equal to 3600";
    private GoogleCredentials sourceCredentials;
    private String targetPrincipal;
    private List<String> delegates;
    private List<String> scopes;
    private int lifetime;
    private final String transportFactoryClassName;
    private transient HttpTransportFactory transportFactory;

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime, HttpTransportFactory transportFactory) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).setHttpTransportFactory(transportFactory).build();
    }

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).build();
    }

    @Override
    public String getAccount() {
        return this.targetPrincipal;
    }

    @Override
    public byte[] sign(byte[] toSign) {
        return IamUtils.sign(this.getAccount(), this.sourceCredentials, this.transportFactory.create(), toSign, ImmutableMap.of("delegates", this.delegates));
    }

    private ImpersonatedCredentials(Builder builder) {
        this.sourceCredentials = builder.getSourceCredentials();
        this.targetPrincipal = builder.getTargetPrincipal();
        this.delegates = builder.getDelegates();
        this.scopes = builder.getScopes();
        this.lifetime = builder.getLifetime();
        this.transportFactory = MoreObjects.firstNonNull(builder.getHttpTransportFactory(), ImpersonatedCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        if (this.delegates == null) {
            this.delegates = new ArrayList<String>();
        }
        if (this.scopes == null) {
            throw new IllegalStateException(SCOPE_EMPTY_ERROR);
        }
        if (this.lifetime > 3600) {
            throw new IllegalStateException(LIFETIME_EXCEEDED_ERROR);
        }
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        Date date;
        if (this.sourceCredentials.getAccessToken() == null) {
            this.sourceCredentials = this.sourceCredentials.createScoped(Arrays.asList(CLOUD_PLATFORM_SCOPE));
        }
        try {
            this.sourceCredentials.refreshIfExpired();
        }
        catch (IOException e) {
            throw new IOException("Unable to refresh sourceCredentials", e);
        }
        HttpTransport httpTransport = this.transportFactory.create();
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(this.sourceCredentials);
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        String endpointUrl = String.format(IAM_ACCESS_TOKEN_ENDPOINT, this.targetPrincipal);
        GenericUrl url = new GenericUrl(endpointUrl);
        ImmutableMap<String, String> body = ImmutableMap.of("delegates", this.delegates, "scope", this.scopes, "lifetime", this.lifetime + "s");
        JsonHttpContent requestContent = new JsonHttpContent(parser.getJsonFactory(), body);
        HttpRequest request = requestFactory.buildPostRequest(url, requestContent);
        adapter.initialize(request);
        request.setParser(parser);
        HttpResponse response = null;
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new IOException("Error requesting access token", e);
        }
        GenericData responseData = response.parseAs(GenericData.class);
        response.disconnect();
        String accessToken = OAuth2Utils.validateString(responseData, "accessToken", "Expected to find an accessToken");
        String expireTime = OAuth2Utils.validateString(responseData, "expireTime", "Expected to find an expireTime");
        SimpleDateFormat format = new SimpleDateFormat(RFC3339);
        try {
            date = format.parse(expireTime);
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing expireTime: " + pe.getMessage());
        }
        return new AccessToken(accessToken, date);
    }

    @Override
    @Beta
    public IdToken idTokenWithAudience(String targetAudience, List<IdTokenProvider.Option> options) throws IOException {
        boolean includeEmail = options != null && options.contains((Object)IdTokenProvider.Option.INCLUDE_EMAIL);
        return IamUtils.getIdToken(this.getAccount(), this.sourceCredentials, this.transportFactory.create(), targetAudience, includeEmail, ImmutableMap.of("delegates", this.delegates));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sourceCredentials, this.targetPrincipal, this.delegates, this.scopes, this.lifetime);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("sourceCredentials", this.sourceCredentials).add("targetPrincipal", this.targetPrincipal).add("delegates", this.delegates).add("scopes", this.scopes).add("lifetime", this.lifetime).add("transportFactoryClassName", this.transportFactoryClassName).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ImpersonatedCredentials)) {
            return false;
        }
        ImpersonatedCredentials other = (ImpersonatedCredentials)obj;
        return Objects.equals(this.sourceCredentials, other.sourceCredentials) && Objects.equals(this.targetPrincipal, other.targetPrincipal) && Objects.equals(this.delegates, other.delegates) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.lifetime, other.lifetime) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.sourceCredentials, this.targetPrincipal);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private GoogleCredentials sourceCredentials;
        private String targetPrincipal;
        private List<String> delegates;
        private List<String> scopes;
        private int lifetime;
        private HttpTransportFactory transportFactory;

        protected Builder() {
        }

        protected Builder(GoogleCredentials sourceCredentials, String targetPrincipal) {
            this.sourceCredentials = sourceCredentials;
            this.targetPrincipal = targetPrincipal;
        }

        public Builder setSourceCredentials(GoogleCredentials sourceCredentials) {
            this.sourceCredentials = sourceCredentials;
            return this;
        }

        public GoogleCredentials getSourceCredentials() {
            return this.sourceCredentials;
        }

        public Builder setTargetPrincipal(String targetPrincipal) {
            this.targetPrincipal = targetPrincipal;
            return this;
        }

        public String getTargetPrincipal() {
            return this.targetPrincipal;
        }

        public Builder setDelegates(List<String> delegates) {
            this.delegates = delegates;
            return this;
        }

        public List<String> getDelegates() {
            return this.delegates;
        }

        public Builder setScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public Builder setLifetime(int lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        @Override
        public ImpersonatedCredentials build() {
            return new ImpersonatedCredentials(this);
        }
    }
}

