/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.ClientProto;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.StorageGrpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.StorageOuterClass;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util.Durations;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCallListener;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.GoogleDefaultChannelBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class StorageStubProvider {
    private static final double GRPC_MAX_RETRY_ATTEMPTS = 10.0;
    private static final int MEDIA_CHANNEL_MAX_POOL_SIZE = 12;
    private static final String DEFAULT_GCS_GRPC_SERVER_ADDRESS = StorageOuterClass.getDescriptor().findServiceByName("Storage").getOptions().getExtension(ClientProto.defaultHost);
    private final GoogleCloudStorageReadOptions readOptions;
    private final ExecutorService backgroundTasksThreadPool;
    private final List<ChannelAndRequestCounter> mediaChannelPool;

    public StorageStubProvider(GoogleCloudStorageReadOptions readOptions, ExecutorService backgroundTasksThreadPool) {
        this.readOptions = readOptions;
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
        this.mediaChannelPool = new ArrayList<ChannelAndRequestCounter>();
    }

    private ChannelAndRequestCounter buildManagedChannel() {
        ActiveRequestCounter counter = new ActiveRequestCounter();
        ManagedChannel channel = ((GoogleDefaultChannelBuilder)((GoogleDefaultChannelBuilder)((GoogleDefaultChannelBuilder)GoogleDefaultChannelBuilder.forTarget(Strings.isNullOrEmpty(this.readOptions.getGrpcServerAddress()) ? DEFAULT_GCS_GRPC_SERVER_ADDRESS : this.readOptions.getGrpcServerAddress()).enableRetry()).defaultServiceConfig((Map)this.getGrpcServiceConfig())).intercept(new ClientInterceptor[]{counter})).build();
        return new ChannelAndRequestCounter(channel, counter);
    }

    public StorageGrpc.StorageBlockingStub getBlockingStub() {
        return StorageGrpc.newBlockingStub(this.getManagedChannel());
    }

    public StorageGrpc.StorageStub getAsyncStub() {
        return (StorageGrpc.StorageStub)StorageGrpc.newStub(this.getManagedChannel()).withExecutor(this.backgroundTasksThreadPool);
    }

    private synchronized ManagedChannel getManagedChannel() {
        if (this.mediaChannelPool.size() >= 12) {
            return this.mediaChannelPool.stream().min(Comparator.comparingInt(ChannelAndRequestCounter::activeRequests)).get().channel;
        }
        ChannelAndRequestCounter channel = this.buildManagedChannel();
        this.mediaChannelPool.add(channel);
        return channel.channel;
    }

    private Map<String, Object> getGrpcServiceConfig() {
        ImmutableMap<String, String> name = ImmutableMap.of("service", "google.storage.v1.Storage");
        ImmutableMap<String, ImmutableList<String>> retryPolicy = ImmutableMap.builder().put("maxAttempts", 10.0).put("initialBackoff", (Double)((Object)Durations.toString(Durations.fromMillis(this.readOptions.getBackoffInitialIntervalMillis())))).put("maxBackoff", (Double)((Object)Durations.toString(Durations.fromMillis(this.readOptions.getBackoffMaxIntervalMillis())))).put("backoffMultiplier", this.readOptions.getBackoffMultiplier()).put("retryableStatusCodes", (Double)((Object)ImmutableList.of("UNAVAILABLE", "RESOURCE_EXHAUSTED"))).build();
        ImmutableMap<String, ImmutableMap<String, ImmutableList<String>>> methodConfig = ImmutableMap.of("name", ImmutableList.of(name), "retryPolicy", retryPolicy);
        ImmutableMap pickFirstStrategy = ImmutableMap.of("pick_first", ImmutableMap.of());
        ImmutableMap childPolicy = ImmutableMap.of("childPolicy", ImmutableList.of(pickFirstStrategy));
        ImmutableMap grpcLbPolicy = ImmutableMap.of("grpclb", childPolicy);
        return ImmutableMap.of("methodConfig", ImmutableList.of(methodConfig), "loadBalancingConfig", ImmutableList.of(grpcLbPolicy));
    }

    public void shutdown() {
        this.mediaChannelPool.parallelStream().forEach(c -> ((ChannelAndRequestCounter)c).channel.shutdownNow());
    }

    class ChannelAndRequestCounter {
        private final ManagedChannel channel;
        private final ActiveRequestCounter counter;

        public ChannelAndRequestCounter(ManagedChannel channel, ActiveRequestCounter counter) {
            this.channel = channel;
            this.counter = counter;
        }

        public int activeRequests() {
            return this.counter.ongoingRequestCount.get();
        }
    }

    final class ActiveRequestCounter
    implements ClientInterceptor {
        private final AtomicInteger ongoingRequestCount = new AtomicInteger(0);

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
            ClientCall<ReqT, RespT> newCall = channel.newCall(methodDescriptor, callOptions);
            final AtomicBoolean countedCancel = new AtomicBoolean(false);
            Context.current().addListener(context -> {
                if (countedCancel.compareAndSet(false, true)) {
                    this.ongoingRequestCount.decrementAndGet();
                }
            }, StorageStubProvider.this.backgroundTasksThreadPool);
            return new ForwardingClientCall.SimpleForwardingClientCall(newCall){

                @Override
                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    if (countedCancel.compareAndSet(false, true)) {
                        ActiveRequestCounter.this.ongoingRequestCount.decrementAndGet();
                    }
                    super.cancel(message, cause);
                }

                @Override
                public void start(ClientCall.Listener responseListener, Metadata headers) {
                    ActiveRequestCounter.this.ongoingRequestCount.incrementAndGet();
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            if (countedCancel.compareAndSet(false, true)) {
                                ActiveRequestCounter.this.ongoingRequestCount.decrementAndGet();
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

