/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HadoopConfigurationProperty;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.StandardSystemProperty;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class HadoopCredentialConfiguration {
    public static final String BASE_KEY_PREFIX = "google.cloud";
    public static final HadoopConfigurationProperty<Boolean> ENABLE_SERVICE_ACCOUNTS_SUFFIX = new HadoopConfigurationProperty<Boolean>(".auth.service.account.enable", true, ".enable.service.account.auth");
    public static final HadoopConfigurationProperty<String> SERVICE_ACCOUNT_EMAIL_SUFFIX = new HadoopConfigurationProperty<Object>(".auth.service.account.email", null, ".service.account.auth.email");
    public static final HadoopConfigurationProperty<String> SERVICE_ACCOUNT_PRIVATE_KEY_ID_SUFFIX = new HadoopConfigurationProperty(".auth.service.account.private.key.id");
    public static final HadoopConfigurationProperty<String> SERVICE_ACCOUNT_PRIVATE_KEY_SUFFIX = new HadoopConfigurationProperty(".auth.service.account.private.key");
    public static final HadoopConfigurationProperty<String> SERVICE_ACCOUNT_KEYFILE_SUFFIX = new HadoopConfigurationProperty<Object>(".auth.service.account.keyfile", null, ".service.account.auth.keyfile");
    public static final HadoopConfigurationProperty<String> SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX = new HadoopConfigurationProperty(".auth.service.account.json.keyfile");
    public static final HadoopConfigurationProperty<String> CLIENT_ID_SUFFIX = new HadoopConfigurationProperty<Object>(".auth.client.id", null, ".client.id");
    public static final HadoopConfigurationProperty<String> CLIENT_SECRET_SUFFIX = new HadoopConfigurationProperty<Object>(".auth.client.secret", null, ".client.secret");
    public static final HadoopConfigurationProperty<String> OAUTH_CLIENT_FILE_SUFFIX = new HadoopConfigurationProperty<String>(".auth.client.file", StandardSystemProperty.USER_HOME.value() + "/.credentials/storage.json", new String[0]);
    public static final HadoopConfigurationProperty<Boolean> ENABLE_NULL_CREDENTIAL_SUFFIX = new HadoopConfigurationProperty<Boolean>(".auth.null.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<String> TOKEN_SERVER_URL_SUFFIX = new HadoopConfigurationProperty<String>(".token.server.url", "https://oauth2.googleapis.com/token", new String[0]);
    public static final HadoopConfigurationProperty<String> PROXY_ADDRESS_SUFFIX = new HadoopConfigurationProperty(".proxy.address");
    public static final HadoopConfigurationProperty<String> PROXY_USERNAME_SUFFIX = new HadoopConfigurationProperty(".proxy.username");
    public static final HadoopConfigurationProperty<String> PROXY_PASSWORD_SUFFIX = new HadoopConfigurationProperty(".proxy.password");
    public static final HadoopConfigurationProperty<HttpTransportFactory.HttpTransportType> HTTP_TRANSPORT_SUFFIX = new HadoopConfigurationProperty<HttpTransportFactory.HttpTransportType>(".http.transport.type", CredentialOptions.HTTP_TRANSPORT_TYPE_DEFAULT, new String[0]);
    public static final HadoopConfigurationProperty<Class<? extends AccessTokenProvider>> ACCESS_TOKEN_PROVIDER_IMPL_SUFFIX = new HadoopConfigurationProperty(".auth.access.token.provider.impl");
    public static final HadoopConfigurationProperty<String> IMPERSONATION_SERVICE_ACCOUNT_SUFFIX = new HadoopConfigurationProperty(".auth.impersonation.service.account");
    public static final HadoopConfigurationProperty<Map<String, String>> USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX = new HadoopConfigurationProperty(".auth.impersonation.service.account.for.user.", ImmutableMap.of(), new String[0]);
    public static final HadoopConfigurationProperty<Map<String, String>> GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX = new HadoopConfigurationProperty(".auth.impersonation.service.account.for.group.", ImmutableMap.of(), new String[0]);

    public static CredentialFactory getCredentialFactory(Configuration config, String ... keyPrefixesVararg) {
        ImmutableList<String> keyPrefixes = HadoopCredentialConfiguration.getConfigKeyPrefixes(keyPrefixesVararg);
        CredentialOptions credentialOptions = CredentialOptions.builder().setServiceAccountEnabled(ENABLE_SERVICE_ACCOUNTS_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setServiceAccountPrivateKeyId(RedactedString.create(SERVICE_ACCOUNT_PRIVATE_KEY_ID_SUFFIX.withPrefixes(keyPrefixes).getPassword(config))).setServiceAccountPrivateKey(RedactedString.create(SERVICE_ACCOUNT_PRIVATE_KEY_SUFFIX.withPrefixes(keyPrefixes).getPassword(config))).setServiceAccountEmail(SERVICE_ACCOUNT_EMAIL_SUFFIX.withPrefixes(keyPrefixes).getPassword(config)).setServiceAccountKeyFile(SERVICE_ACCOUNT_KEYFILE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setServiceAccountJsonKeyFile(SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setClientId(RedactedString.create(CLIENT_ID_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)))).setClientSecret(RedactedString.create(CLIENT_SECRET_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)))).setOAuthCredentialFile(OAUTH_CLIENT_FILE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setNullCredentialEnabled(ENABLE_NULL_CREDENTIAL_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setTransportType(HTTP_TRANSPORT_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setTokenServerUrl(TOKEN_SERVER_URL_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setProxyAddress(PROXY_ADDRESS_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setProxyUsername(RedactedString.create(PROXY_USERNAME_SUFFIX.withPrefixes(keyPrefixes).getPassword(config))).setProxyPassword(RedactedString.create(PROXY_PASSWORD_SUFFIX.withPrefixes(keyPrefixes).getPassword(config))).build();
        return new CredentialFactory(credentialOptions);
    }

    public static Class<? extends AccessTokenProvider> getAccessTokenProviderImplClass(Configuration config, String ... keyPrefixes) {
        return ACCESS_TOKEN_PROVIDER_IMPL_SUFFIX.withPrefixes(HadoopCredentialConfiguration.getConfigKeyPrefixes(keyPrefixes)).get(config, (k, d) -> config.getClass(k, d, AccessTokenProvider.class));
    }

    public static ImmutableList<String> getConfigKeyPrefixes(String ... keyPrefixes) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(keyPrefixes)).add(BASE_KEY_PREFIX)).build();
    }

    protected HadoopCredentialConfiguration() {
    }
}

