/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Stopwatch;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.EquivalentAddressGroup;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb.GrpclbConfig;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb.GrpclbConstants;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb.GrpclbState;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb.LbAddressGroup;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb.SubchannelPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.BackoffPolicy;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.TimeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class GrpclbLoadBalancer
extends LoadBalancer {
    private static final GrpclbConfig DEFAULT_CONFIG = GrpclbConfig.create(GrpclbState.Mode.ROUND_ROBIN);
    private final LoadBalancer.Helper helper;
    private final TimeProvider time;
    private final Stopwatch stopwatch;
    private final SubchannelPool subchannelPool;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private GrpclbConfig config = DEFAULT_CONFIG;
    @Nullable
    private GrpclbState grpclbState;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, SubchannelPool subchannelPool, TimeProvider time, Stopwatch stopwatch, BackoffPolicy.Provider backoffPolicyProvider) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.time = Preconditions.checkNotNull(time, "time provider");
        this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.subchannelPool = Preconditions.checkNotNull(subchannelPool, "subchannelPool");
        this.recreateStates();
        Preconditions.checkNotNull(this.grpclbState, "grpclbState");
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Attributes attributes = resolvedAddresses.getAttributes();
        List<EquivalentAddressGroup> newLbAddresses = attributes.get(GrpclbConstants.ATTR_LB_ADDRS);
        if ((newLbAddresses == null || newLbAddresses.isEmpty()) && resolvedAddresses.getAddresses().isEmpty()) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("No backend or balancer addresses found"));
            return;
        }
        ArrayList<LbAddressGroup> newLbAddressGroups = new ArrayList();
        if (newLbAddresses != null) {
            for (EquivalentAddressGroup lbAddr : newLbAddresses) {
                String lbAddrAuthority = lbAddr.getAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY);
                if (lbAddrAuthority == null) {
                    throw new AssertionError((Object)("This is a bug: LB address " + lbAddr + " does not have an authority."));
                }
                newLbAddressGroups.add(new LbAddressGroup(lbAddr, lbAddrAuthority));
            }
        }
        newLbAddressGroups = Collections.unmodifiableList(newLbAddressGroups);
        List<EquivalentAddressGroup> newBackendServers = Collections.unmodifiableList(resolvedAddresses.getAddresses());
        GrpclbConfig newConfig = (GrpclbConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (newConfig == null) {
            newConfig = DEFAULT_CONFIG;
        }
        if (!this.config.equals(newConfig)) {
            this.config = newConfig;
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Config: " + newConfig);
            this.recreateStates();
        }
        this.grpclbState.handleAddresses(newLbAddressGroups, newBackendServers);
    }

    @Override
    public void requestConnection() {
        if (this.grpclbState != null) {
            this.grpclbState.requestConnection();
        }
    }

    private void resetStates() {
        if (this.grpclbState != null) {
            this.grpclbState.shutdown();
            this.grpclbState = null;
        }
    }

    private void recreateStates() {
        this.resetStates();
        Preconditions.checkState(this.grpclbState == null, "Should've been cleared");
        this.grpclbState = new GrpclbState(this.config, this.helper, this.subchannelPool, this.time, this.stopwatch, this.backoffPolicyProvider);
    }

    @Override
    public void shutdown() {
        this.resetStates();
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.grpclbState != null) {
            this.grpclbState.propagateError(error);
        }
    }

    @Override
    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    @Nullable
    @VisibleForTesting
    GrpclbState getGrpclbState() {
        return this.grpclbState;
    }
}

