/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CacheEntry;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class CachedBucket
extends CacheEntry {
    private final SortedMap<String, CacheEntry> objectLookup = new TreeMap<String, CacheEntry>();

    public CachedBucket(String bucketName) {
        super(new StorageResourceId(bucketName));
    }

    public CachedBucket(GoogleCloudStorageItemInfo bucketItemInfo) {
        super(bucketItemInfo);
        Preconditions.checkArgument((boolean)bucketItemInfo.isBucket(), (Object)"CachedBucket requires bucketItemInfo.isBucket() to be true");
    }

    public String getName() {
        return this.getResourceId().getBucketName();
    }

    private void validateStorageObjectId(StorageResourceId resourceId) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null.");
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)String.format("resourceId must be a StorageObject, got: %s", resourceId));
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(this.getName()), (Object)String.format("resourceId.getBucketName() (%s) doesn't match this.getName() (%s)", resourceId.getBucketName(), this.getName()));
    }

    public synchronized CacheEntry get(StorageResourceId resourceId) {
        this.validateStorageObjectId(resourceId);
        return (CacheEntry)this.objectLookup.get(resourceId.getObjectName());
    }

    public synchronized void remove(StorageResourceId resourceId) {
        this.validateStorageObjectId(resourceId);
        this.objectLookup.remove(resourceId.getObjectName());
    }

    public synchronized CacheEntry put(StorageResourceId resourceId) {
        this.validateStorageObjectId(resourceId);
        CacheEntry returnEntry = (CacheEntry)this.objectLookup.get(resourceId.getObjectName());
        if (returnEntry == null) {
            returnEntry = new CacheEntry(resourceId);
            this.objectLookup.put(resourceId.getObjectName(), returnEntry);
        }
        return returnEntry;
    }

    public synchronized List<CacheEntry> getObjectList() {
        return ImmutableList.copyOf(this.objectLookup.values());
    }

    public synchronized List<CacheEntry> getObjectList(String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return this.getObjectList();
        }
        return ImmutableList.copyOf(this.objectLookup.subMap(prefix, prefix + '\uffff').values());
    }

    public synchronized int getNumObjects() {
        return this.objectLookup.size();
    }
}

